/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.esma.emir.refit.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ReportableDelivery;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.GetReportableDelivery;
import drr.regulation.esma.emir.refit.trade.DeliveryReport;
import drr.regulation.esma.emir.refit.trade.reports.CurrencyOfThePriceTimeIntervalQuantityRule;
import drr.regulation.esma.emir.refit.trade.reports.DaysOfTheWeekRule;
import drr.regulation.esma.emir.refit.trade.reports.DeliveryCapacityRule;
import drr.regulation.esma.emir.refit.trade.reports.DeliveryEndDateRule;
import drr.regulation.esma.emir.refit.trade.reports.DeliveryIntervalEndTimeRule;
import drr.regulation.esma.emir.refit.trade.reports.DeliveryIntervalStartTimeRule;
import drr.regulation.esma.emir.refit.trade.reports.DeliveryStartDateRule;
import drr.regulation.esma.emir.refit.trade.reports.DurationRule;
import drr.regulation.esma.emir.refit.trade.reports.PriceTimeIntervalQuantityRule;
import drr.regulation.esma.emir.refit.trade.reports.QuantityUnitRule;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=DeliveryRuleDefault.class)
public abstract class DeliveryRule
implements ReportFunction<TransactionReportInstruction, List<? extends DeliveryReport>> {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected CurrencyOfThePriceTimeIntervalQuantityRule currencyOfThePriceTimeIntervalQuantityRule;
    @Inject
    protected DaysOfTheWeekRule daysOfTheWeekRule;
    @Inject
    protected DeliveryCapacityRule deliveryCapacityRule;
    @Inject
    protected DeliveryEndDateRule deliveryEndDateRule;
    @Inject
    protected DeliveryIntervalEndTimeRule deliveryIntervalEndTimeRule;
    @Inject
    protected DeliveryIntervalStartTimeRule deliveryIntervalStartTimeRule;
    @Inject
    protected DeliveryStartDateRule deliveryStartDateRule;
    @Inject
    protected DurationRule durationRule;
    @Inject
    protected GetReportableDelivery getReportableDelivery;
    @Inject
    protected PriceTimeIntervalQuantityRule priceTimeIntervalQuantityRule;
    @Inject
    protected QuantityUnitRule quantityUnitRule;

    public List<? extends DeliveryReport> evaluate(TransactionReportInstruction input) {
        List output;
        List<DeliveryReport.DeliveryReportBuilder> outputBuilder = this.doEvaluate(input);
        if (outputBuilder == null) {
            output = null;
        } else {
            output = outputBuilder.stream().map(DeliveryReport::build).collect(Collectors.toList());
            this.objectValidator.validate(DeliveryReport.class, output);
        }
        return output;
    }

    protected abstract List<DeliveryReport.DeliveryReportBuilder> doEvaluate(TransactionReportInstruction var1);

    public static class DeliveryRuleDefault
    extends DeliveryRule {
        @Override
        protected List<DeliveryReport.DeliveryReportBuilder> doEvaluate(TransactionReportInstruction input) {
            ArrayList<DeliveryReport.DeliveryReportBuilder> output = new ArrayList<DeliveryReport.DeliveryReportBuilder>();
            return this.assignOutput(output, input);
        }

        protected List<DeliveryReport.DeliveryReportBuilder> assignOutput(List<DeliveryReport.DeliveryReportBuilder> output, TransactionReportInstruction input) {
            MapperC thenArg = MapperS.of((Object)input).mapSingleToList(item -> MapperC.of(this.getReportableDelivery.evaluate((ReportableEvent)item.get())));
            output = this.toBuilder(thenArg.mapItem(item -> MapperS.of((Object)DeliveryReport.builder().setDeliveryStartTime(this.deliveryIntervalStartTimeRule.evaluate((ReportableDelivery)item.get())).setDeliveryEndTime(this.deliveryIntervalEndTimeRule.evaluate((ReportableDelivery)item.get())).setDeliveryStartDate(this.deliveryStartDateRule.evaluate((ReportableDelivery)item.get())).setDeliveryEndDate(this.deliveryEndDateRule.evaluate((ReportableDelivery)item.get())).setDuration(this.durationRule.evaluate((ReportableDelivery)item.get())).setDaysOfTheWeek(this.daysOfTheWeekRule.evaluate((ReportableDelivery)item.get())).setDeliveryCapacity(this.deliveryCapacityRule.evaluate((ReportableDelivery)item.get())).setQuantityUnit(this.quantityUnitRule.evaluate((ReportableDelivery)item.get())).setPriceTimeIntervalQuantity(this.priceTimeIntervalQuantityRule.evaluate((ReportableDelivery)item.get())).setCurrencyOfThePriceTimeIntervalQuantity(this.currencyOfThePriceTimeIntervalQuantityRule.evaluate((ReportableDelivery)item.get())).build())).getMulti());
            return Optional.ofNullable(output).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }
    }
}

