/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.jfsa.rewrite.trade.reports;

import cdm.base.staticdata.identifier.TradeIdentifierTypeEnum;
import cdm.event.common.TradeIdentifier;
import cdm.event.workflow.WorkflowStep;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.BeforeTradeForEvent;
import drr.regulation.common.functions.IsActionTypeNEWT;
import drr.regulation.common.functions.IsCleared;
import drr.regulation.common.functions.IsMax32UpperCaseAlphanumericText;
import drr.regulation.jfsa.rewrite.trade.functions.IsAllowableActionForJFSA;
import drr.standards.iosco.cde.reports.CDEEventTypeRule;
import javax.inject.Inject;

@ImplementedBy(value=OriginalSwapUTIRuleDefault.class)
public abstract class OriginalSwapUTIRule
implements ReportFunction<TransactionReportInstruction, String> {
    @Inject
    protected BeforeTradeForEvent beforeTradeForEvent;
    @Inject
    protected CDEEventTypeRule cDEEventTypeRule;
    @Inject
    protected IsActionTypeNEWT isActionTypeNEWT;
    @Inject
    protected IsAllowableActionForJFSA isAllowableActionForJFSA;
    @Inject
    protected IsCleared isCleared;
    @Inject
    protected IsMax32UpperCaseAlphanumericText isMax32UpperCaseAlphanumericText;

    public String evaluate(TransactionReportInstruction input) {
        String output = this.doEvaluate(input);
        return output;
    }

    protected abstract String doEvaluate(TransactionReportInstruction var1);

    public static class OriginalSwapUTIRuleDefault
    extends OriginalSwapUTIRule {
        @Override
        protected String doEvaluate(TransactionReportInstruction input) {
            String output = null;
            return this.assignOutput(output, input);
        }

        protected String assignOutput(String output, TransactionReportInstruction input) {
            MapperS thenArg0 = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableActionForJFSA.evaluate((ReportableEvent)item.get()));
            MapperS thenArg1 = thenArg0.mapSingleToItem(item -> {
                if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)this.isCleared.evaluate((WorkflowStep)item.map("getOriginatingWorkflowStep", transactionReportInstruction -> transactionReportInstruction.getOriginatingWorkflowStep()).get())), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)this.isActionTypeNEWT.evaluate((ReportableEvent)item.get())), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All)).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)this.cDEEventTypeRule.evaluate((TransactionReportInstruction)item.get())), (Mapper)MapperS.of((Object)"CLRG"), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)this.beforeTradeForEvent.evaluate((ReportableEvent)item.get()));
                }
                return MapperS.ofNull();
            });
            MapperC thenArg2 = thenArg1.mapSingleToList(item -> item.mapC("getTradeIdentifier", trade -> trade.getTradeIdentifier()));
            MapperC thenArg3 = thenArg2.filterItemNullSafe(item -> ExpressionOperators.areEqual((Mapper)item.map("getIdentifierType", tradeIdentifier -> tradeIdentifier.getIdentifierType()), (Mapper)MapperS.of((Object)TradeIdentifierTypeEnum.UNIQUE_TRANSACTION_IDENTIFIER), (CardinalityOperator)CardinalityOperator.All).get());
            MapperS thenArg4 = MapperS.of((Object)((TradeIdentifier)thenArg3.get()));
            MapperC thenArg5 = thenArg4.mapSingleToList(item -> item.mapC("getAssignedIdentifier", tradeIdentifier -> tradeIdentifier.getAssignedIdentifier()).map("getIdentifier", assignedIdentifier -> assignedIdentifier.getIdentifier()));
            MapperC thenArg6 = thenArg5.filterItemNullSafe(item -> {
                FieldWithMetaString _fieldWithMetaString = (FieldWithMetaString)item.get();
                return ExpressionOperators.areEqual((Mapper)MapperS.of((Object)this.isMax32UpperCaseAlphanumericText.evaluate(_fieldWithMetaString == null ? null : _fieldWithMetaString.getValue())), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All).get();
            });
            FieldWithMetaString fieldWithMetaString = (FieldWithMetaString)thenArg6.last().get();
            output = fieldWithMetaString == null ? null : fieldWithMetaString.getValue();
            return output;
        }
    }
}

