/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.mas.rewrite.trade.reports;

import cdm.product.asset.InterestRatePayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.InterestRateLeg1;
import drr.regulation.common.functions.ProductForEvent;
import drr.regulation.common.functions.ProductOrUnderlierProduct;
import drr.regulation.mas.rewrite.trade.functions.IsAllowableActionForMAS;
import drr.standards.iosco.cde.reports.CDEDayCountConventionRule;
import iso20022.auth030.mas.InterestComputationMethod4Code;
import javax.inject.Inject;

@ImplementedBy(value=FixedRateDayCountConventionOfLeg1RuleDefault.class)
public abstract class FixedRateDayCountConventionOfLeg1Rule
implements ReportFunction<TransactionReportInstruction, InterestComputationMethod4Code> {
    @Inject
    protected CDEDayCountConventionRule cDEDayCountConventionRule;
    @Inject
    protected InterestRateLeg1 interestRateLeg1;
    @Inject
    protected IsAllowableActionForMAS isAllowableActionForMAS;
    @Inject
    protected ProductForEvent productForEvent;
    @Inject
    protected ProductOrUnderlierProduct productOrUnderlierProduct;

    public InterestComputationMethod4Code evaluate(TransactionReportInstruction input) {
        InterestComputationMethod4Code output = this.doEvaluate(input);
        return output;
    }

    protected abstract InterestComputationMethod4Code doEvaluate(TransactionReportInstruction var1);

    public static class FixedRateDayCountConventionOfLeg1RuleDefault
    extends FixedRateDayCountConventionOfLeg1Rule {
        @Override
        protected InterestComputationMethod4Code doEvaluate(TransactionReportInstruction input) {
            InterestComputationMethod4Code output = null;
            return this.assignOutput(output, input);
        }

        protected InterestComputationMethod4Code assignOutput(InterestComputationMethod4Code output, TransactionReportInstruction input) {
            MapperS thenArg0 = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableActionForMAS.evaluate((ReportableEvent)item.get()));
            MapperS thenArg1 = thenArg0.mapSingleToItem(item -> MapperS.of((Object)this.productForEvent.evaluate((ReportableEvent)item.get())));
            MapperS thenArg2 = thenArg1.mapSingleToItem(item -> MapperS.of((Object)this.productOrUnderlierProduct.evaluate((Product)item.get())));
            MapperS thenArg3 = thenArg2.mapSingleToItem(item -> MapperS.of((Object)this.interestRateLeg1.evaluate((Product)item.get())));
            MapperS thenArg4 = thenArg3.filterSingleNullSafe(item -> ExpressionOperators.exists((Mapper)item.map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).map("getFixedRate", rateSpecification -> rateSpecification.getFixedRate())).get());
            output = (InterestComputationMethod4Code)thenArg4.mapSingleToItem(item -> MapperS.of((Object)this.cDEDayCountConventionRule.evaluate((InterestRatePayout)item.get())).checkedMap("to-enum", e -> InterestComputationMethod4Code.valueOf((String)e.name()), IllegalArgumentException.class)).get();
            return output;
        }
    }
}

