/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.techsprint.g20.mas.reports;

import cdm.base.staticdata.party.Address;
import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.PartyRoleEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.ExtractPartyFromRelatedPartyByRole;
import drr.regulation.techsprint.g20.mas.functions.LookupBookingLocation;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=BookingLocationAddressRuleDefault.class)
public abstract class BookingLocationAddressRule
implements ReportFunction<TransactionReportInstruction, Address> {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected ExtractPartyFromRelatedPartyByRole extractPartyFromRelatedPartyByRole;
    @Inject
    protected LookupBookingLocation lookupBookingLocation;

    public Address evaluate(TransactionReportInstruction input) {
        Address output;
        Address.AddressBuilder outputBuilder = this.doEvaluate(input);
        if (outputBuilder == null) {
            output = null;
        } else {
            output = outputBuilder.build();
            this.objectValidator.validate(Address.class, (RosettaModelObject)output);
        }
        return output;
    }

    protected abstract Address.AddressBuilder doEvaluate(TransactionReportInstruction var1);

    public static class BookingLocationAddressRuleDefault
    extends BookingLocationAddressRule {
        @Override
        protected Address.AddressBuilder doEvaluate(TransactionReportInstruction input) {
            Address.AddressBuilder output = Address.builder();
            return this.assignOutput(output, input);
        }

        protected Address.AddressBuilder assignOutput(Address.AddressBuilder output, TransactionReportInstruction input) {
            MapperS thenArg = MapperS.of((Object)input).mapSingleToItem(item -> MapperS.of((Object)this.extractPartyFromRelatedPartyByRole.evaluate(item.map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).mapC("getPartyInformation", reportableInformation -> reportableInformation.getPartyInformation()).mapC("getRelatedParty", partyInformation -> partyInformation.getRelatedParty()).getMulti(), PartyRoleEnum.REPORTING_PARTY)));
            output = (Address.AddressBuilder)this.toBuilder((RosettaModelObject)thenArg.mapSingleToItem(item -> MapperS.of((Object)this.lookupBookingLocation.evaluate((Party)item.get()))).get());
            return Optional.ofNullable(output).map(o -> o.prune()).orElse(null);
        }
    }
}

