/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.techsprint.g20.mas.reports;

import cdm.event.common.Trade;
import cdm.event.common.TradeState;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=ContractForEventRuleDefault.class)
public abstract class ContractForEventRule
implements ReportFunction<TransactionReportInstruction, Trade> {
    @Inject
    protected ModelObjectValidator objectValidator;

    public Trade evaluate(TransactionReportInstruction input) {
        Trade output;
        Trade.TradeBuilder outputBuilder = this.doEvaluate(input);
        if (outputBuilder == null) {
            output = null;
        } else {
            output = outputBuilder.build();
            this.objectValidator.validate(Trade.class, (RosettaModelObject)output);
        }
        return output;
    }

    protected abstract Trade.TradeBuilder doEvaluate(TransactionReportInstruction var1);

    public static class ContractForEventRuleDefault
    extends ContractForEventRule {
        @Override
        protected Trade.TradeBuilder doEvaluate(TransactionReportInstruction input) {
            Trade.TradeBuilder output = Trade.builder();
            return this.assignOutput(output, input);
        }

        protected Trade.TradeBuilder assignOutput(Trade.TradeBuilder output, TransactionReportInstruction input) {
            output = (Trade.TradeBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)input).mapSingleToItem(item -> MapperS.of((Object)((TradeState)item.map("getOriginatingWorkflowStep", transactionReportInstruction -> transactionReportInstruction.getOriginatingWorkflowStep()).map("getBusinessEvent", workflowStep -> workflowStep.getBusinessEvent()).mapC("getAfter", businessEvent -> businessEvent.getAfter()).get())).map("getTrade", tradeState -> tradeState.getTrade())).get());
            return Optional.ofNullable(output).map(o -> o.prune()).orElse(null);
        }
    }
}

