/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.functions;

import cdm.base.math.metafields.ReferenceWithMetaNonNegativeQuantitySchedule;
import cdm.product.template.PerformancePayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;

@ImplementedBy(value=CDEPerformanceNotionalDefault.class)
public abstract class CDEPerformanceNotional
implements RosettaFunction {
    public BigDecimal evaluate(List<? extends PerformancePayout> performancePayout) {
        BigDecimal amount = this.doEvaluate(performancePayout);
        return amount;
    }

    protected abstract BigDecimal doEvaluate(List<? extends PerformancePayout> var1);

    protected abstract MapperS<? extends ReferenceWithMetaNonNegativeQuantitySchedule> quantity(List<? extends PerformancePayout> var1);

    protected abstract MapperS<BigDecimal> multipliedQuantity(List<? extends PerformancePayout> var1);

    public static class CDEPerformanceNotionalDefault
    extends CDEPerformanceNotional {
        @Override
        protected BigDecimal doEvaluate(List<? extends PerformancePayout> performancePayout) {
            if (performancePayout == null) {
                performancePayout = Collections.emptyList();
            }
            BigDecimal amount = null;
            return this.assignOutput(amount, performancePayout);
        }

        protected BigDecimal assignOutput(BigDecimal amount, List<? extends PerformancePayout> performancePayout) {
            amount = ExpressionOperators.exists((Mapper)this.quantity(performancePayout).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule -> referenceWithMetaNonNegativeQuantitySchedule == null ? null : referenceWithMetaNonNegativeQuantitySchedule.getValue()).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency())).getOrDefault(Boolean.valueOf(false)) != false ? (BigDecimal)this.multipliedQuantity(performancePayout).get() : null;
            return amount;
        }

        @Override
        protected MapperS<? extends ReferenceWithMetaNonNegativeQuantitySchedule> quantity(List<? extends PerformancePayout> performancePayout) {
            return MapperS.of((Object)((PerformancePayout)MapperC.of(performancePayout).get())).map("getPriceQuantity", _performancePayout -> _performancePayout.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule());
        }

        @Override
        protected MapperS<BigDecimal> multipliedQuantity(List<? extends PerformancePayout> performancePayout) {
            if (ExpressionOperators.exists((Mapper)this.quantity(performancePayout).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule0 -> referenceWithMetaNonNegativeQuantitySchedule0 == null ? null : referenceWithMetaNonNegativeQuantitySchedule0.getValue()).map("getMultiplier", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getMultiplier())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperMaths.multiply((Mapper)this.quantity(performancePayout).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule1 -> referenceWithMetaNonNegativeQuantitySchedule1 == null ? null : referenceWithMetaNonNegativeQuantitySchedule1.getValue()).map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()), (Mapper)this.quantity(performancePayout).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule2 -> referenceWithMetaNonNegativeQuantitySchedule2 == null ? null : referenceWithMetaNonNegativeQuantitySchedule2.getValue()).map("getMultiplier", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getMultiplier()).map("getValue", measure -> measure.getValue()));
            }
            return this.quantity(performancePayout).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule3 -> referenceWithMetaNonNegativeQuantitySchedule3 == null ? null : referenceWithMetaNonNegativeQuantitySchedule3.getValue()).map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue());
        }
    }
}

