/*
 * Decompiled with CFR 0.152.
 */
package com.rosetta.model.lib;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.rosetta.model.lib.ModelId;
import com.rosetta.util.DottedPath;
import java.util.Objects;

public class ModelSymbolId
extends ModelId
implements Comparable<ModelSymbolId> {
    private final String name;

    public ModelSymbolId(DottedPath namespace, String name) {
        super(namespace);
        Objects.requireNonNull(namespace);
        Objects.requireNonNull(name);
        this.name = name;
    }

    @JsonCreator
    public static ModelSymbolId fromQualifiedName(String str) {
        DottedPath qualifiedName = DottedPath.splitOnDots(str);
        return new ModelSymbolId(qualifiedName.parent(), qualifiedName.last());
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getAlphanumericName() {
        return this.name;
    }

    @JsonValue
    public DottedPath getQualifiedName() {
        return this.getNamespace().child(this.name);
    }

    public String toString() {
        return this.getQualifiedName().withDots();
    }

    public int hashCode() {
        return Objects.hash(this.name, this.getNamespace());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModelSymbolId other = (ModelSymbolId)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.getNamespace(), other.getNamespace());
    }

    @Override
    public int compareTo(ModelSymbolId o) {
        return this.getQualifiedName().compareTo(o.getQualifiedName());
    }
}

