/*
 * Decompiled with CFR 0.152.
 */
package com.rosetta.model.lib.mapper;

import com.google.common.base.CaseFormat;
import com.rosetta.model.lib.mapper.Mapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.stream.Collectors;

class MapperPath
implements Mapper.Path,
Comparable<MapperPath> {
    private final List<PathElement> pathElements;

    public MapperPath(MapperPathBuilder builder) {
        this.pathElements = builder.pathElements;
    }

    @Override
    public List<String> getNames() {
        return Collections.unmodifiableList(this.pathElements.stream().map(PathElement::getName).collect(Collectors.toList()));
    }

    @Override
    public List<String> getGetters() {
        return Collections.unmodifiableList(this.pathElements.stream().map(PathElement::getGetter).collect(Collectors.toList()));
    }

    @Override
    public String getLastName() {
        return this.getNames().get(this.getNames().size() - 1);
    }

    @Override
    public String getFullPath() {
        return String.join((CharSequence)"->", this.pathElements.stream().map(PathElement::getGetterAndContext).collect(Collectors.toList()));
    }

    public String toString() {
        return this.getFullPath();
    }

    public static MapperPathBuilder builder() {
        return new MapperPathBuilder();
    }

    public MapperPathBuilder toBuilder() {
        return new MapperPathBuilder(this.pathElements);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.pathElements == null ? 0 : this.pathElements.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MapperPath other = (MapperPath)obj;
        return !(this.pathElements == null ? other.pathElements != null : !this.pathElements.equals(other.pathElements));
    }

    @Override
    public int compareTo(MapperPath other) {
        ListIterator<PathElement> i1 = this.pathElements.listIterator();
        ListIterator<PathElement> i2 = other.pathElements.listIterator();
        while (i1.hasNext() && i2.hasNext()) {
            int result = i1.next().compareTo(i2.next());
            if (result == 0) continue;
            return result;
        }
        if (!i1.hasNext() && !i2.hasNext()) {
            return 0;
        }
        if (i2.hasNext()) {
            return 1;
        }
        return -1;
    }

    public static class MapperPathBuilder {
        private final List<PathElement> pathElements;

        public MapperPathBuilder() {
            this.pathElements = new ArrayList<PathElement>();
        }

        public MapperPathBuilder(List<PathElement> pathElements) {
            this.pathElements = new ArrayList<PathElement>(pathElements);
        }

        public MapperPath addNull() {
            this.pathElements.add(new PathElement("Null"));
            return new MapperPath(this);
        }

        public MapperPath addRoot(Class<?> clazz) {
            String name = clazz.getSimpleName();
            this.pathElements.add(new PathElement(name));
            return new MapperPath(this);
        }

        public MapperPath addFunctionName(String name) {
            this.pathElements.add(new PathElement(name));
            return new MapperPath(this);
        }

        public MapperPath addListFunctionName(String name, int listIndex) {
            this.pathElements.add(new PathElement(name, listIndex));
            return new MapperPath(this);
        }
    }

    private static class PathElement
    implements Comparable<PathElement> {
        private final String name;
        private final String getter;
        private final Optional<Integer> listIndex;
        private final String getterAndContext;

        public PathElement(String getter) {
            this(PathElement.toAttributeName(getter), getter, Optional.empty());
        }

        public PathElement(String getter, int listIndex) {
            this(PathElement.toAttributeName(getter), getter, Optional.of(listIndex));
        }

        private PathElement(String name, String getter, Optional<Integer> listIndex) {
            this.name = name;
            this.getter = getter;
            this.listIndex = listIndex;
            this.getterAndContext = listIndex.map(i -> String.format("%s[%s]", getter, i)).orElse(getter);
        }

        public String getName() {
            return this.name;
        }

        public String getGetter() {
            return this.getter;
        }

        public String getGetterAndContext() {
            return this.getterAndContext;
        }

        private static String toAttributeName(String getter) {
            if (getter.startsWith("get")) {
                return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, getter.substring(3));
            }
            return getter;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.getter == null ? 0 : this.getter.hashCode());
            result = 31 * result + (this.listIndex == null ? 0 : this.listIndex.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PathElement other = (PathElement)obj;
            if (this.getter == null ? other.getter != null : !this.getter.equals(other.getter)) {
                return false;
            }
            if (this.listIndex == null ? other.listIndex != null : !this.listIndex.equals(other.listIndex)) {
                return false;
            }
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        @Override
        public int compareTo(PathElement other) {
            int nameCompare = this.name.compareTo(other.name);
            if (nameCompare != 0) {
                return nameCompare;
            }
            if (this.listIndex.isPresent() && other.listIndex.isPresent()) {
                return this.listIndex.get().compareTo(other.listIndex.get());
            }
            if (this.listIndex.isPresent()) {
                return -1;
            }
            if (other.listIndex.isPresent()) {
                return 1;
            }
            return 0;
        }
    }
}

