# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
import sys
import datetime
import inspect
from decimal import Decimal
from rosetta.runtime.utils import *
from rosetta.runtime.func_proxy import replaceable, create_module_attr_guardian
from cdm.base.math.UnitType import UnitType
from cdm.base.math.functions.StringEquals import StringEquals

__all__ = ['UnitEquals']


@replaceable
def UnitEquals(u1: UnitType | None, u2: UnitType | None) -> bool:
    """
    Compares two UnitType to check if all attributes match.
    
    Parameters 
    ----------
    u1 : UnitType
    
    u2 : UnitType
    
    Returns
    -------
    result : boolean
    
    """
    self = inspect.currentframe()
    
    
    def _then_fn0():
        return StringEquals(rosetta_resolve_attr(rosetta_resolve_attr(self, "u1"), "currency"), rosetta_resolve_attr(rosetta_resolve_attr(self, "u2"), "currency"))
    
    def _else_fn0():
        return all_elements(rosetta_resolve_attr(self, "u1"), "=", rosetta_resolve_attr(self, "u2"))
    
    result =  if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(self, "u1"), "currency")), _then_fn0, _else_fn0)
    
    
    return result

sys.modules[__name__].__class__ = create_module_attr_guardian(sys.modules[__name__].__class__)
