# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['SettlementOrigin']


class SettlementOrigin(BaseDataClass):
    """
    Defines the origin to the transfer as a reference for lineage purposes, whether it originated from trade level settlement terms or from payment terms on an economic payout.
    """
    commodityPayout: Optional[AttributeWithReference | cdm.product.asset.CommodityPayout.CommodityPayout] = Field(None, description="Represents a reference to an Commodity Payout.")
    """
    Represents a reference to an Commodity Payout.
    """
    creditDefaultPayout: Optional[AttributeWithReference | cdm.product.asset.CreditDefaultPayout.CreditDefaultPayout] = Field(None, description="Represents a reference to a Credit Default Payout.")
    """
    Represents a reference to a Credit Default Payout.
    """
    forwardPayout: Optional[AttributeWithReference | cdm.product.template.ForwardPayout.ForwardPayout] = Field(None, description="Represents a reference to a Forward Payout.")
    """
    Represents a reference to a Forward Payout.
    """
    interestRatePayout: Optional[AttributeWithReference | cdm.product.asset.InterestRatePayout.InterestRatePayout] = Field(None, description="Represents a reference to an Interest Rate Payout.")
    """
    Represents a reference to an Interest Rate Payout.
    """
    optionPayout: Optional[AttributeWithReference | cdm.product.template.OptionPayout.OptionPayout] = Field(None, description="Represents a reference to an Option Payout.")
    """
    Represents a reference to an Option Payout.
    """
    assetPayout: Optional[AttributeWithReference | cdm.product.template.AssetPayout.AssetPayout] = Field(None, description="Represents a reference to an Asset Payout.")
    """
    Represents a reference to an Asset Payout.
    """
    settlementTerms: Optional[AttributeWithReference | cdm.product.common.settlement.SettlementTerms.SettlementTerms] = Field(None, description="Represents a reference to settlement terms, which may have been specified at execution.")
    """
    Represents a reference to settlement terms, which may have been specified at execution.
    """
    performancePayout: Optional[AttributeWithReference | cdm.product.template.PerformancePayout.PerformancePayout] = Field(None, description="Represents a reference to a Performance Payout.")
    """
    Represents a reference to a Performance Payout.
    """
    fixedPricePayout: Optional[AttributeWithReference | cdm.product.template.FixedPricePayout.FixedPricePayout] = Field(None, description="Represents a reference to a Fixed Price Payout")
    """
    Represents a reference to a Fixed Price Payout
    """
    
    @rosetta_condition
    def condition_0_(self):
        item = self
        return rosetta_check_one_of(self, 'commodityPayout', 'creditDefaultPayout', 'forwardPayout', 'interestRatePayout', 'optionPayout', 'assetPayout', 'settlementTerms', 'performancePayout', 'fixedPricePayout', necessity=True)

import cdm 
import cdm.product.asset.CommodityPayout
import cdm.product.asset.CreditDefaultPayout
import cdm.product.template.ForwardPayout
import cdm.product.asset.InterestRatePayout
import cdm.product.template.OptionPayout
import cdm.product.template.AssetPayout
import cdm.product.common.settlement.SettlementTerms
import cdm.product.template.PerformancePayout
import cdm.product.template.FixedPricePayout
