# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
import sys
import datetime
import inspect
from decimal import Decimal
from rosetta.runtime.utils import *
from rosetta.runtime.func_proxy import replaceable, create_module_attr_guardian
from cdm.event.common.functions.NewFloatingPayout import NewFloatingPayout
from cdm.base.staticdata.asset.common.SecurityTypeEnum import SecurityTypeEnum
from cdm.product.template.Product import Product
from cdm.base.staticdata.asset.common.Security import Security
from cdm.legaldocumentation.master.EquitySwapMasterConfirmation2018 import EquitySwapMasterConfirmation2018
from cdm.event.common.functions.NewSingleNameEquityPerformancePayout import NewSingleNameEquityPerformancePayout

__all__ = ['NewEquitySwapProduct']


@replaceable
def NewEquitySwapProduct(security: Security, masterConfirmation: EquitySwapMasterConfirmation2018 | None) -> Product:
    """
    Function specification to create an Equity Swap according to the 2018 ISDA CDM Equity Confirmation Template, based on a minimum set of inputs which can (optionally) include a Master Confirmation Agreement. The inputs represent the minimum set of inputs required to create an Equity Swap, either based on an existing Master Confirmation Agreement or as a stand-alone Equity Swap
    
    Parameters 
    ----------
    security : Security
    The underlying Equity asset for the swap.
    
    masterConfirmation : EquitySwapMasterConfirmation2018
    An (optional) pointer to the Master Confirmation Agreement, if any, that holds further inputs to the Equity Swap
    
    Returns
    -------
    product : Product
    
    """
    _pre_registry = {}
    _post_registry = {}
    self = inspect.currentframe()
    
    # conditions
    
    @rosetta_local_condition(_pre_registry)
    def condition_0_EquitySecurityType(self):
        """
        Security must be equity (single name).
        """
        return all_elements(rosetta_resolve_attr(rosetta_resolve_attr(self, "security"), "securityType"), "=", rosetta_resolve_attr(SecurityTypeEnum, "EQUITY"))
    # Execute all registered conditions
    execute_local_conditions(_pre_registry, 'Pre-condition')
    
    def _then_fn0():
        return NewFloatingPayout(rosetta_resolve_attr(self, "masterConfirmation"))
    
    def _else_fn0():
        return True
    
    payout = rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "product"), "contractualProduct"), "economicTerms"), "payout")
    product = NewSingleNameEquityPerformancePayout(rosetta_resolve_attr(self, "security"), rosetta_resolve_attr(self, "masterConfirmation"))
    product.add_rosetta_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, product), 'contractualProduct'), 'economicTerms'), 'payout'), 'interestRatePayout'), if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(self, "masterConfirmation")), _then_fn0, _else_fn0))
    
    # post-conditions
    
    @rosetta_local_condition(_post_registry)
    def condition_0_PayoutType(self):
        """
        Other payout types must be absent.
        """
        def _then_fn0():
            return ((((((not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "interestRatePayout"))) and (not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "cashflow")))) and (not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "creditDefaultPayout")))) and (not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "forwardPayout")))) and (not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "fixedPricePayout")))) and (not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(self, "payout"), "optionPayout"))))
        
        def _else_fn0():
            return True
        
        return if_cond_fn((not rosetta_attr_exists(rosetta_resolve_attr(self, "masterConfirmation"))), _then_fn0, _else_fn0)
    
    @rosetta_local_condition(_post_registry)
    def condition_1_ContractualProductOnlyExists(self):
        """
        Non-contractual product types must be absent.
        """
        return rosetta_check_one_of(self, rosetta_resolve_attr(rosetta_resolve_attr(self, "product"), "contractualProduct"))
    # Execute all registered post-conditions
    execute_local_conditions(_post_registry, 'Post-condition')
    
    return product

sys.modules[__name__].__class__ = create_module_attr_guardian(sys.modules[__name__].__class__)
