# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['CollateralProvisions']


class CollateralProvisions(BaseDataClass):
    """
    Contains collateral attributes which can also inherit information from a GMRA
    """
    collateralType: cdm.product.collateral.CollateralTypeEnum.CollateralTypeEnum = Field(..., description="Enumerates the collateral types which are accepted by the Seller.")
    """
    Enumerates the collateral types which are accepted by the Seller.
    """
    eligibleCollateral: List[cdm.product.collateral.EligibleCollateralCriteria.EligibleCollateralCriteria] = Field([], description="The eligible collateral as specified in relation to the transaction.")
    """
    The eligible collateral as specified in relation to the transaction.
    """
    substitutionProvisions: Optional[cdm.product.collateral.SubstitutionProvisions.SubstitutionProvisions] = Field(None, description="The provisions for collateral substitutions such as how many and when they are allowed.")
    """
    The provisions for collateral substitutions such as how many and when they are allowed.
    """

import cdm 
import cdm.product.collateral.CollateralTypeEnum
import cdm.product.collateral.EligibleCollateralCriteria
import cdm.product.collateral.SubstitutionProvisions
