# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['CollateralTreatment']


class CollateralTreatment(BaseDataClass):
    """
    Specifies the treatment terms for the eligible collateral criteria specified.
    """
    valuationTreatment: Optional[cdm.product.collateral.CollateralValuationTreatment.CollateralValuationTreatment] = Field(None, description="Specification of the valuation treatment for the specified collateral.")
    """
    Specification of the valuation treatment for the specified collateral.
    """
    concentrationLimit: List[cdm.product.collateral.ConcentrationLimit.ConcentrationLimit] = Field([], description="Specification of concentration limits applicable to the collateral criteria.")
    """
    Specification of concentration limits applicable to the collateral criteria.
    """
    isIncluded: bool = Field(..., description="A boolean attribute to specify whether collateral critieria are inclusion (True) or exclusion (False) criteria.")
    """
    A boolean attribute to specify whether collateral critieria are inclusion (True) or exclusion (False) criteria.
    """

import cdm 
import cdm.product.collateral.CollateralValuationTreatment
import cdm.product.collateral.ConcentrationLimit
