# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
import sys
import datetime
import inspect
from decimal import Decimal
from rosetta.runtime.utils import *
from rosetta.runtime.func_proxy import replaceable, create_module_attr_guardian
from cdm.product.common.settlement.functions.UpdatePriceAmountForEachMatchingQuantity import UpdatePriceAmountForEachMatchingQuantity
from cdm.product.common.settlement.PriceQuantity import PriceQuantity
from cdm.product.common.settlement.functions.UpdateQuantityAmountForEachMatchingQuantity import UpdateQuantityAmountForEachMatchingQuantity
from cdm.base.math.QuantityChangeDirectionEnum import QuantityChangeDirectionEnum

__all__ = ['UpdateAmountForEachMatchingQuantity']


@replaceable
def UpdateAmountForEachMatchingQuantity(priceQuantityList: list[PriceQuantity], change: list[PriceQuantity], direction: QuantityChangeDirectionEnum) -> PriceQuantity:
    """
    Updates any price or quantity from the list of PriceQuantity if the unit of amount matches.
    
    Parameters 
    ----------
    priceQuantityList : PriceQuantity
    List of PriceQuantity to update.
    
    change : PriceQuantity
    List of new PriceQuantity to use where the units match.
    
    direction : QuantityChangeDirectionEnum
    Enum specifying how the updated amounts should be applied, e.g., add, subtract or replace.
    
    Returns
    -------
    updatedPriceQuantity : PriceQuantity
    
    """
    self = inspect.currentframe()
    
    
    updatedPriceQuantity = list(map(lambda item: PriceQuantity(price=list(map(lambda item: UpdatePriceAmountForEachMatchingQuantity(item, rosetta_resolve_attr(rosetta_resolve_attr(self, "change"), "price"), rosetta_resolve_attr(self, "direction")), rosetta_resolve_attr(rosetta_resolve_attr(self, "priceQuantity"), "price"))), quantity=list(map(lambda item: UpdateQuantityAmountForEachMatchingQuantity(item, rosetta_resolve_attr(rosetta_resolve_attr(self, "change"), "quantity"), rosetta_resolve_attr(self, "direction")), rosetta_resolve_attr(rosetta_resolve_attr(self, "priceQuantity"), "quantity"))), observable=rosetta_resolve_attr(rosetta_resolve_attr(self, "priceQuantity"), "observable"), buyerSeller=rosetta_resolve_attr(rosetta_resolve_attr(self, "priceQuantity"), "buyerSeller"), settlementTerms=rosetta_resolve_attr(rosetta_resolve_attr(self, "priceQuantity"), "settlementTerms"), effectiveDate=rosetta_resolve_attr(rosetta_resolve_attr(self, "priceQuantity"), "effectiveDate")), rosetta_resolve_attr(self, "priceQuantityList")))
    
    
    return updatedPriceQuantity

sys.modules[__name__].__class__ = create_module_attr_guardian(sys.modules[__name__].__class__)
