# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
import sys
import datetime
import inspect
from decimal import Decimal
from rosetta.runtime.utils import *
from rosetta.runtime.func_proxy import replaceable, create_module_attr_guardian
from cdm.product.template.EconomicTerms import EconomicTerms
from cdm.base.staticdata.asset.common.AssetClassEnum import AssetClassEnum

__all__ = ['Qualify_AssetClass_Commodity']


@replaceable
def Qualify_AssetClass_Commodity(economicTerms: EconomicTerms) -> bool:
    """
    Qualifies a product as having the Asset Class classification Commodity
    
    Parameters 
    ----------
    economicTerms : EconomicTerms
    
    Returns
    -------
    is_product : boolean
    
    """
    self = inspect.currentframe()
    
    
    def _then_fn0():
        return ((((all_elements(Qualify_AssetClass_Commodity(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "optionUnderlier"), "contractualProduct"), "economicTerms")), "=", True) or all_elements(Qualify_AssetClass_Commodity(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "optionUnderlier"), "security"), "economicTerms")), "=", True)) or rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(self, "optionUnderlier"), "commodity"))) or all_elements(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "optionUnderlier"), "index"), "productTaxonomy"), "primaryAssetClass"), "=", rosetta_resolve_attr(AssetClassEnum, "COMMODITY"))) or all_elements(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "optionUnderlier"), "security"), "productTaxonomy"), "primaryAssetClass"), "=", rosetta_resolve_attr(AssetClassEnum, "COMMODITY")))
    
    def _else_fn0():
        return False
    
    optionUnderlier = rosetta_resolve_attr(get_only_element(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "payout"), "optionPayout")), "underlier")
    forwardUnderlier = rosetta_resolve_attr(get_only_element(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "payout"), "forwardPayout")), "underlier")
    is_product =  ((((rosetta_check_one_of(self, rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "payout"), "commodityPayout")) and rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "payout"), "commodityPayout"), "underlier"), "commodity"))) or ((rosetta_check_one_of(self, rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "payout"), "commodityPayout")) and all_elements(rosetta_count(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "payout"), "commodityPayout")), "=", 2)) and all_elements(rosetta_count(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "payout"), "commodityPayout"), "underlier"), "commodity")), "=", 2))) or (rosetta_check_one_of(self, rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "payout"), "optionPayout")) and if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(self, "optionUnderlier")), _then_fn0, _else_fn0))) or (((rosetta_check_one_of(self, rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "payout"), "forwardPayout")) or rosetta_check_one_of(self, rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "payout"), "forwardPayout"))) or rosetta_check_one_of(self, rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "payout"), "forwardPayout"))) and ((rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "payout"), "forwardPayout"), "underlier"), "commodity")) or all_elements(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "forwardUnderlier"), "index"), "productTaxonomy"), "primaryAssetClass"), "=", rosetta_resolve_attr(AssetClassEnum, "COMMODITY"))) or all_elements(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "forwardUnderlier"), "security"), "productTaxonomy"), "primaryAssetClass"), "=", rosetta_resolve_attr(AssetClassEnum, "COMMODITY")))))
    
    
    return is_product

sys.modules[__name__].__class__ = create_module_attr_guardian(sys.modules[__name__].__class__)
