# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['AutomaticExercise']


class AutomaticExercise(BaseDataClass):
    """
    A type to define automatic exercise of a swaption. With automatic exercise the option is deemed to have exercised if it is in the money by more than the threshold amount on the exercise date.
    """
    thresholdRate: Optional[Decimal] = Field(None, description="A threshold rate. The threshold of 0.10% would be represented as 0.001")
    """
    A threshold rate. The threshold of 0.10% would be represented as 0.001
    """
    isApplicable: Optional[bool] = Field(None, description="Boolean that indicates if it has an automaticExercise")
    """
    Boolean that indicates if it has an automaticExercise
    """

import cdm 
