# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
import sys
import datetime
import inspect
from decimal import Decimal
from rosetta.runtime.utils import *
from rosetta.runtime.func_proxy import replaceable, create_module_attr_guardian
from cdm.base.datetime.BusinessCenterTime import BusinessCenterTime
from cdm.product.template.ExpirationTimeTypeEnum import ExpirationTimeTypeEnum

__all__ = ['ExpirationTimeType']


@replaceable
def ExpirationTimeType(expirationTime: BusinessCenterTime | None, expirationTimeType: ExpirationTimeTypeEnum | None) -> bool:
    """
    Conditional Validation function to check the existence of correlation between expiration Time and expiration Time Type.
    
    Parameters 
    ----------
    expirationTime : BusinessCenterTime
    
    expirationTimeType : ExpirationTimeTypeEnum
    
    Returns
    -------
    success : boolean
    
    """
    self = inspect.currentframe()
    
    
    def _then_fn0():
        return all_elements(rosetta_resolve_attr(self, "expirationTimeType"), "=", rosetta_resolve_attr(ExpirationTimeTypeEnum, "SPECIFIC_TIME"))
    
    def _else_fn0():
        return True
    
    def _then_fn0():
        return rosetta_attr_exists(rosetta_resolve_attr(self, "expirationTime"))
    
    def _else_fn0():
        return True
    
    success =  (if_cond_fn((rosetta_attr_exists(rosetta_resolve_attr(self, "expirationTime")) and rosetta_attr_exists(rosetta_resolve_attr(self, "expirationTimeType"))), _then_fn0, _else_fn0) and if_cond_fn((rosetta_attr_exists(rosetta_resolve_attr(self, "expirationTimeType")) and all_elements(rosetta_resolve_attr(self, "expirationTimeType"), "=", rosetta_resolve_attr(ExpirationTimeTypeEnum, "SPECIFIC_TIME"))), _then_fn0, _else_fn0))
    
    
    return success

sys.modules[__name__].__class__ = create_module_attr_guardian(sys.modules[__name__].__class__)
