package drr.projection.iso20022.esma.emir.refit.margin.functions;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.esma.emir.refit.margin.CollateralReport;
import iso20022.auth108.esma.ActiveOrHistoricCurrencyAnd5DecimalAmount;
import iso20022.auth108.esma.ReceivedMarginOrCollateral6__1;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;


@ImplementedBy(Create_ReceivedMarginReport.Create_ReceivedMarginReportDefault.class)
public abstract class Create_ReceivedMarginReport implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;

	/**
	* @param collateralReport 
	* @return rcvdMarginData 
	*/
	public ReceivedMarginOrCollateral6__1 evaluate(CollateralReport collateralReport) {
		ReceivedMarginOrCollateral6__1.ReceivedMarginOrCollateral6__1Builder rcvdMarginDataBuilder = doEvaluate(collateralReport);
		
		final ReceivedMarginOrCollateral6__1 rcvdMarginData;
		if (rcvdMarginDataBuilder == null) {
			rcvdMarginData = null;
		} else {
			rcvdMarginData = rcvdMarginDataBuilder.build();
			objectValidator.validate(ReceivedMarginOrCollateral6__1.class, rcvdMarginData);
		}
		
		return rcvdMarginData;
	}

	protected abstract ReceivedMarginOrCollateral6__1.ReceivedMarginOrCollateral6__1Builder doEvaluate(CollateralReport collateralReport);

	public static class Create_ReceivedMarginReportDefault extends Create_ReceivedMarginReport {
		@Override
		protected ReceivedMarginOrCollateral6__1.ReceivedMarginOrCollateral6__1Builder doEvaluate(CollateralReport collateralReport) {
			ReceivedMarginOrCollateral6__1.ReceivedMarginOrCollateral6__1Builder rcvdMarginData = ReceivedMarginOrCollateral6__1.builder();
			return assignOutput(rcvdMarginData, collateralReport);
		}
		
		protected ReceivedMarginOrCollateral6__1.ReceivedMarginOrCollateral6__1Builder assignOutput(ReceivedMarginOrCollateral6__1.ReceivedMarginOrCollateral6__1Builder rcvdMarginData, CollateralReport collateralReport) {
			rcvdMarginData = toBuilder(ReceivedMarginOrCollateral6__1.builder()
				.setInitlMrgnRcvdPreHrcut(ActiveOrHistoricCurrencyAnd5DecimalAmount.builder()
					.setValue(MapperS.of(collateralReport).<BigDecimal>map("getInitialMarginCollectedByCounterparty1PreHaircut", _collateralReport -> _collateralReport.getInitialMarginCollectedByCounterparty1PreHaircut()).get())
					.setCcy(MapperS.of(collateralReport).<ISOCurrencyCodeEnum>map("getInitialMarginCollectedByCounterparty1Currency", _collateralReport -> _collateralReport.getInitialMarginCollectedByCounterparty1Currency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get())
					.build())
				.setInitlMrgnRcvdPstHrcut(ActiveOrHistoricCurrencyAnd5DecimalAmount.builder()
					.setValue(MapperS.of(collateralReport).<BigDecimal>map("getInitialMarginCollectedByCounterparty1PostHaircut", _collateralReport -> _collateralReport.getInitialMarginCollectedByCounterparty1PostHaircut()).get())
					.setCcy(MapperS.of(collateralReport).<ISOCurrencyCodeEnum>map("getInitialMarginCollectedByCounterparty1Currency", _collateralReport -> _collateralReport.getInitialMarginCollectedByCounterparty1Currency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get())
					.build())
				.setVartnMrgnRcvdPreHrcut(ActiveOrHistoricCurrencyAnd5DecimalAmount.builder()
					.setValue(MapperS.of(collateralReport).<BigDecimal>map("getVariationMarginCollectedByTheCounterparty1PreHaircut", _collateralReport -> _collateralReport.getVariationMarginCollectedByTheCounterparty1PreHaircut()).get())
					.setCcy(MapperS.of(collateralReport).<ISOCurrencyCodeEnum>map("getVariationMarginCollectedByCounterparty1Currency", _collateralReport -> _collateralReport.getVariationMarginCollectedByCounterparty1Currency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get())
					.build())
				.setVartnMrgnRcvdPstHrcut(ActiveOrHistoricCurrencyAnd5DecimalAmount.builder()
					.setValue(MapperS.of(collateralReport).<BigDecimal>map("getVariationMarginCollectedByTheCounterparty1PostHaircut", _collateralReport -> _collateralReport.getVariationMarginCollectedByTheCounterparty1PostHaircut()).get())
					.setCcy(MapperS.of(collateralReport).<ISOCurrencyCodeEnum>map("getVariationMarginCollectedByCounterparty1Currency", _collateralReport -> _collateralReport.getVariationMarginCollectedByCounterparty1Currency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get())
					.build())
				.setXcssCollRcvd(ActiveOrHistoricCurrencyAnd5DecimalAmount.builder()
					.setValue(MapperS.of(collateralReport).<BigDecimal>map("getExcessCollateralCollectedByTheCounterparty1", _collateralReport -> _collateralReport.getExcessCollateralCollectedByTheCounterparty1()).get())
					.setCcy(MapperS.of(collateralReport).<String>map("getCurrencyOfTheExcessCollateralCollected", _collateralReport -> _collateralReport.getCurrencyOfTheExcessCollateralCollected()).map("to-string", Object::toString).get())
					.build())
				.build());
			
			return Optional.ofNullable(rcvdMarginData)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
