package drr.projection.iso20022.esma.emir.refit.trade.functions;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.esma.emir.refit.trade.ESMAEMIRTransactionReport;
import iso20022.auth030.esma.BasketConstituents3__1;
import iso20022.auth030.esma.ContractType14__1;
import iso20022.auth030.esma.CurrencyExchange23__1;
import iso20022.auth030.esma.CustomBasket4__1;
import iso20022.auth030.esma.FinancialInstrumentContractType2Code;
import iso20022.auth030.esma.FloatingRateIndex1Code;
import iso20022.auth030.esma.IndexIdentification1__1;
import iso20022.auth030.esma.InstrumentIdentification6Choice__1;
import iso20022.auth030.esma.ProductType4Code__1;
import iso20022.auth030.esma.SecurityIdentification41Choice__1;
import iso20022.auth030.esma.SecurityIdentification46__1;
import iso20022.auth030.esma.UniqueProductIdentifier2Choice__1;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(Create_ContractType14__1.Create_ContractType14__1Default.class)
public abstract class Create_ContractType14__1 implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;

	/**
	* @param drrReport 
	* @return ctrctData 
	*/
	public ContractType14__1 evaluate(ESMAEMIRTransactionReport drrReport) {
		ContractType14__1.ContractType14__1Builder ctrctDataBuilder = doEvaluate(drrReport);
		
		final ContractType14__1 ctrctData;
		if (ctrctDataBuilder == null) {
			ctrctData = null;
		} else {
			ctrctData = ctrctDataBuilder.build();
			objectValidator.validate(ContractType14__1.class, ctrctData);
		}
		
		return ctrctData;
	}

	protected abstract ContractType14__1.ContractType14__1Builder doEvaluate(ESMAEMIRTransactionReport drrReport);

	public static class Create_ContractType14__1Default extends Create_ContractType14__1 {
		@Override
		protected ContractType14__1.ContractType14__1Builder doEvaluate(ESMAEMIRTransactionReport drrReport) {
			ContractType14__1.ContractType14__1Builder ctrctData = ContractType14__1.builder();
			return assignOutput(ctrctData, drrReport);
		}
		
		protected ContractType14__1.ContractType14__1Builder assignOutput(ContractType14__1.ContractType14__1Builder ctrctData, ESMAEMIRTransactionReport drrReport) {
			String ifThenElseResult0 = null;
			if (areEqual(MapperS.of(drrReport).<String>map("getUnderlyingIdentificationType", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getUnderlyingIdentificationType()), MapperS.of("I"), CardinalityOperator.All).getOrDefault(false)) {
				ifThenElseResult0 = MapperS.of(drrReport).<String>map("getUnderlyingIdentification", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getUnderlyingIdentification()).get();
			}
			FloatingRateIndex1Code ifThenElseResult1 = null;
			if (areEqual(MapperS.of(drrReport).<String>map("getUnderlyingIdentificationType", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getUnderlyingIdentificationType()), MapperS.of("X"), CardinalityOperator.All).getOrDefault(false)) {
				ifThenElseResult1 = MapperS.of(drrReport).<String>mapC("getIndicatorOfTheUnderlyingIndex", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getIndicatorOfTheUnderlyingIndex())
					.last().checkedMap("to-enum", FloatingRateIndex1Code::fromDisplayName, IllegalArgumentException.class).get();
			}
			String ifThenElseResult2 = null;
			if (areEqual(MapperS.of(drrReport).<String>map("getUnderlyingIdentificationType", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getUnderlyingIdentificationType()), MapperS.of("X"), CardinalityOperator.All).getOrDefault(false)) {
				ifThenElseResult2 = MapperS.of(drrReport).<String>mapC("getNameOfTheUnderlyingIndex", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getNameOfTheUnderlyingIndex())
					.last().get();
			}
			ctrctData = toBuilder(ContractType14__1.builder()
				.setPdctId(SecurityIdentification46__1.builder()
					.setIsin(MapperS.of(drrReport).<String>map("getIsin", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getIsin()).get())
					.setUnqPdctIdr(UniqueProductIdentifier2Choice__1.builder()
						.setId(MapperS.of(drrReport).<String>map("getUpi", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getUpi()).get())
						.build())
					.build())
				.setPdctClssfctn(MapperS.of(drrReport).<String>map("getProductClassification", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getProductClassification()).get())
				.setCtrctTp(MapperS.of(drrReport).<String>map("getContractType", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getContractType()).checkedMap("to-enum", FinancialInstrumentContractType2Code::fromDisplayName, IllegalArgumentException.class).get())
				.setAsstClss(MapperS.of(drrReport).<String>map("getAssetClass", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getAssetClass()).checkedMap("to-enum", ProductType4Code__1::fromDisplayName, IllegalArgumentException.class).get())
				.setDerivBasedOnCrptAsst(MapperS.of(drrReport).<Boolean>map("getIsCrypto", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getIsCrypto()).get())
				.setUndrlygInstrm(SecurityIdentification41Choice__1.builder()
					.setIsin(ifThenElseResult0)
					.setIndx(IndexIdentification1__1.builder()
						.setIndx(ifThenElseResult1)
						.setNm(ifThenElseResult2)
						.build())
					.setBskt(CustomBasket4__1.builder()
						.setId(MapperS.of(drrReport).<String>map("getCustomBasketCode", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getCustomBasketCode()).get())
						.setCnsttnts(MapperS.of(drrReport).<String>mapC("getIdentifierOfBasketConstituents", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getIdentifierOfBasketConstituents())
							.mapItem(item -> MapperS.of(BasketConstituents3__1.builder()
								.setInstrmId(InstrumentIdentification6Choice__1.builder()
									.setIsin(item.get())
									.build())
								.build())).getMulti())
						.build())
					.build())
				.setSttlmCcy(CurrencyExchange23__1.builder()
					.setCcy(MapperS.of(drrReport).<ISOCurrencyCodeEnum>map("getSettlementCurrency1", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getSettlementCurrency1()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get())
					.build())
				.setSttlmCcyScndLeg(CurrencyExchange23__1.builder()
					.setCcy(MapperS.of(drrReport).<ISOCurrencyCodeEnum>map("getSettlementCurrency2", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getSettlementCurrency2()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get())
					.build())
				.build());
			
			return Optional.ofNullable(ctrctData)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
