package drr.projection.iso20022.esma.emir.refit.trade.functions;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.esma.emir.refit.trade.ESMAEMIRTransactionReport;
import drr.regulation.esma.emir.refit.trade.SpreadOfLeg1;
import drr.regulation.esma.emir.refit.trade.SpreadOfLeg2;
import drr.standards.iso.PriceNotationEnum;
import iso20022.auth030.esma.Frequency13Code__1;
import iso20022.auth030.esma.InterestComputationMethod4Code;
import iso20022.auth030.esma.InterestRate33Choice__1;
import iso20022.auth030.esma.InterestRateLegs14__1;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;


@ImplementedBy(GetIntrstRate.GetIntrstRateDefault.class)
public abstract class GetIntrstRate implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected Create_FixedRate create_FixedRate;
	@Inject protected Create_FloatingRate create_FloatingRate;

	/**
	* @param drrReport 
	* @return intrstRate 
	*/
	public InterestRateLegs14__1 evaluate(ESMAEMIRTransactionReport drrReport) {
		InterestRateLegs14__1.InterestRateLegs14__1Builder intrstRateBuilder = doEvaluate(drrReport);
		
		final InterestRateLegs14__1 intrstRate;
		if (intrstRateBuilder == null) {
			intrstRate = null;
		} else {
			intrstRate = intrstRateBuilder.build();
			objectValidator.validate(InterestRateLegs14__1.class, intrstRate);
		}
		
		return intrstRate;
	}

	protected abstract InterestRateLegs14__1.InterestRateLegs14__1Builder doEvaluate(ESMAEMIRTransactionReport drrReport);

	public static class GetIntrstRateDefault extends GetIntrstRate {
		@Override
		protected InterestRateLegs14__1.InterestRateLegs14__1Builder doEvaluate(ESMAEMIRTransactionReport drrReport) {
			InterestRateLegs14__1.InterestRateLegs14__1Builder intrstRate = InterestRateLegs14__1.builder();
			return assignOutput(intrstRate, drrReport);
		}
		
		protected InterestRateLegs14__1.InterestRateLegs14__1Builder assignOutput(InterestRateLegs14__1.InterestRateLegs14__1Builder intrstRate, ESMAEMIRTransactionReport drrReport) {
			intrstRate = toBuilder(InterestRateLegs14__1.builder()
				.setFrstLeg(InterestRate33Choice__1.builder()
					.setFxd(create_FixedRate.evaluate(MapperS.of(drrReport).<BigDecimal>map("getFixedRateOfLeg1", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getFixedRateOfLeg1()).get(), MapperS.of(drrReport).<InterestComputationMethod4Code>map("getFixedRateDayCountConventionLeg1", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getFixedRateDayCountConventionLeg1()).get(), MapperS.of(drrReport).<String>map("getFixedRatePaymentFrequencyPeriodLeg1", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getFixedRatePaymentFrequencyPeriodLeg1()).get(), MapperS.of(drrReport).<Integer>map("getFixedRatePaymentFrequencyPeriodMultiplierLeg1", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getFixedRatePaymentFrequencyPeriodMultiplierLeg1()).get()))
					.setFltg(create_FloatingRate.evaluate(MapperS.of(drrReport).<String>map("getIdentifierOfFloatingRateOfLeg1", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getIdentifierOfFloatingRateOfLeg1()).get(), MapperS.of(drrReport).<String>map("getNameOfTheFloatingRateOfLeg1", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getNameOfTheFloatingRateOfLeg1()).get(), MapperS.of(drrReport).<String>map("getIndicatorOfTheFloatingRateOfLeg1", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getIndicatorOfTheFloatingRateOfLeg1()).get(), MapperS.of(drrReport).<String>map("getFloatingRateReferencePeriodOfLeg1TimePeriod", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getFloatingRateReferencePeriodOfLeg1TimePeriod()).get(), MapperS.of(drrReport).<Integer>map("getFloatingRateReferencePeriodOfLeg1Multiplier", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getFloatingRateReferencePeriodOfLeg1Multiplier()).get(), MapperS.of(drrReport).<SpreadOfLeg1>map("getSpreadOfLeg1", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getSpreadOfLeg1()).<BigDecimal>map("getSpreadOfLeg1Monetary", spreadOfLeg1 -> spreadOfLeg1.getSpreadOfLeg1Monetary()).get(), MapperS.of(drrReport).<SpreadOfLeg1>map("getSpreadOfLeg1", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getSpreadOfLeg1()).<BigDecimal>map("getSpreadOfLeg1Percentage", spreadOfLeg1 -> spreadOfLeg1.getSpreadOfLeg1Percentage()).get(), MapperS.of(drrReport).<SpreadOfLeg1>map("getSpreadOfLeg1", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getSpreadOfLeg1()).<BigDecimal>map("getSpreadOfLeg1Basis", spreadOfLeg1 -> spreadOfLeg1.getSpreadOfLeg1Basis()).get(), MapperS.of(drrReport).<SpreadOfLeg1>map("getSpreadOfLeg1", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getSpreadOfLeg1()).<ISOCurrencyCodeEnum>map("getSpreadCurrencyOfLeg1", spreadOfLeg1 -> spreadOfLeg1.getSpreadCurrencyOfLeg1()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get(), MapperS.of(drrReport).<SpreadOfLeg1>map("getSpreadOfLeg1", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getSpreadOfLeg1()).<PriceNotationEnum>map("getSpreadOfLeg1Notation", spreadOfLeg1 -> spreadOfLeg1.getSpreadOfLeg1Notation()).get(), MapperS.of(drrReport).<InterestComputationMethod4Code>map("getFloatingRateDayCountConventionOfLeg1", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getFloatingRateDayCountConventionOfLeg1()).get(), MapperS.of(drrReport).<Frequency13Code__1>map("getFloatingRatePaymentFrequencyPeriodOfLeg1", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getFloatingRatePaymentFrequencyPeriodOfLeg1()).get(), MapperS.of(drrReport).<Integer>map("getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1()).get(), MapperS.of(drrReport).<String>map("getFloatingRateResetFrequencyPeriodOfLeg1", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getFloatingRateResetFrequencyPeriodOfLeg1()).get(), MapperS.of(drrReport).<Integer>map("getFloatingRateResetFrequencyPeriodMultiplierLeg1", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getFloatingRateResetFrequencyPeriodMultiplierLeg1()).get()))
					.build())
				.setScndLeg(InterestRate33Choice__1.builder()
					.setFxd(create_FixedRate.evaluate(MapperS.of(drrReport).<BigDecimal>map("getFixedRateOfLeg2", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getFixedRateOfLeg2()).get(), MapperS.of(drrReport).<InterestComputationMethod4Code>map("getFixedRateDayCountConventionLeg2", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getFixedRateDayCountConventionLeg2()).get(), MapperS.of(drrReport).<String>map("getFixedRatePaymentFrequencyPeriodLeg2", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getFixedRatePaymentFrequencyPeriodLeg2()).get(), MapperS.of(drrReport).<Integer>map("getFixedRatePaymentFrequencyPeriodMultiplierLeg2", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getFixedRatePaymentFrequencyPeriodMultiplierLeg2()).get()))
					.setFltg(create_FloatingRate.evaluate(MapperS.of(drrReport).<String>map("getIdentifierOfFloatingRateOfLeg2", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getIdentifierOfFloatingRateOfLeg2()).get(), MapperS.of(drrReport).<String>map("getNameOfTheFloatingRateOfLeg2", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getNameOfTheFloatingRateOfLeg2()).get(), MapperS.of(drrReport).<String>map("getIndicatorOfTheFloatingRateOfLeg2", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getIndicatorOfTheFloatingRateOfLeg2()).get(), MapperS.of(drrReport).<String>map("getFloatingRateReferencePeriodOfLeg2TimePeriod", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getFloatingRateReferencePeriodOfLeg2TimePeriod()).get(), MapperS.of(drrReport).<Integer>map("getFloatingRateReferencePeriodOfLeg2Multiplier", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getFloatingRateReferencePeriodOfLeg2Multiplier()).get(), MapperS.of(drrReport).<SpreadOfLeg2>map("getSpreadOfLeg2", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getSpreadOfLeg2()).<BigDecimal>map("getSpreadOfLeg2Monetary", spreadOfLeg2 -> spreadOfLeg2.getSpreadOfLeg2Monetary()).get(), MapperS.of(drrReport).<SpreadOfLeg2>map("getSpreadOfLeg2", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getSpreadOfLeg2()).<BigDecimal>map("getSpreadOfLeg2Percentage", spreadOfLeg2 -> spreadOfLeg2.getSpreadOfLeg2Percentage()).get(), MapperS.of(drrReport).<SpreadOfLeg2>map("getSpreadOfLeg2", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getSpreadOfLeg2()).<BigDecimal>map("getSpreadOfLeg2Basis", spreadOfLeg2 -> spreadOfLeg2.getSpreadOfLeg2Basis()).get(), MapperS.of(drrReport).<SpreadOfLeg2>map("getSpreadOfLeg2", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getSpreadOfLeg2()).<ISOCurrencyCodeEnum>map("getSpreadCurrencyOfLeg2", spreadOfLeg2 -> spreadOfLeg2.getSpreadCurrencyOfLeg2()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get(), MapperS.of(drrReport).<SpreadOfLeg2>map("getSpreadOfLeg2", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getSpreadOfLeg2()).<PriceNotationEnum>map("getSpreadOfLeg2Notation", spreadOfLeg2 -> spreadOfLeg2.getSpreadOfLeg2Notation()).get(), MapperS.of(drrReport).<InterestComputationMethod4Code>map("getFloatingRateDayCountConventionOfLeg2", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getFloatingRateDayCountConventionOfLeg2()).get(), MapperS.of(drrReport).<String>map("getFloatingRatePaymentFrequencyPeriodOfLeg2", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getFloatingRatePaymentFrequencyPeriodOfLeg2()).checkedMap("to-enum", Frequency13Code__1::fromDisplayName, IllegalArgumentException.class).get(), MapperS.of(drrReport).<Integer>map("getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2()).get(), MapperS.of(drrReport).<String>map("getFloatingRateResetFrequencyPeriodOfLeg2", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getFloatingRateResetFrequencyPeriodOfLeg2()).get(), MapperS.of(drrReport).<Integer>map("getFloatingRateResetFrequencyPeriodMultiplierLeg2", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getFloatingRateResetFrequencyPeriodMultiplierLeg2()).get()))
					.build())
				.build());
			
			return Optional.ofNullable(intrstRate)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
