package drr.projection.iso20022.fca.ukemir.refit.trade.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.fca.ukemir.refit.trade.FCAUKEMIRTransactionReport;
import iso20022.auth030.fca.GenericIdentification175__3;
import iso20022.auth030.fca.UniqueTransactionIdentifier2Choice__2;
import java.util.Optional;
import javax.inject.Inject;


@ImplementedBy(GetTxId.GetTxIdDefault.class)
public abstract class GetTxId implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;

	/**
	* @param drrReport 
	* @return txId 
	*/
	public UniqueTransactionIdentifier2Choice__2 evaluate(FCAUKEMIRTransactionReport drrReport) {
		UniqueTransactionIdentifier2Choice__2.UniqueTransactionIdentifier2Choice__2Builder txIdBuilder = doEvaluate(drrReport);
		
		final UniqueTransactionIdentifier2Choice__2 txId;
		if (txIdBuilder == null) {
			txId = null;
		} else {
			txId = txIdBuilder.build();
			objectValidator.validate(UniqueTransactionIdentifier2Choice__2.class, txId);
		}
		
		return txId;
	}

	protected abstract UniqueTransactionIdentifier2Choice__2.UniqueTransactionIdentifier2Choice__2Builder doEvaluate(FCAUKEMIRTransactionReport drrReport);

	public static class GetTxIdDefault extends GetTxId {
		@Override
		protected UniqueTransactionIdentifier2Choice__2.UniqueTransactionIdentifier2Choice__2Builder doEvaluate(FCAUKEMIRTransactionReport drrReport) {
			UniqueTransactionIdentifier2Choice__2.UniqueTransactionIdentifier2Choice__2Builder txId = UniqueTransactionIdentifier2Choice__2.builder();
			return assignOutput(txId, drrReport);
		}
		
		protected UniqueTransactionIdentifier2Choice__2.UniqueTransactionIdentifier2Choice__2Builder assignOutput(UniqueTransactionIdentifier2Choice__2.UniqueTransactionIdentifier2Choice__2Builder txId, FCAUKEMIRTransactionReport drrReport) {
			txId = toBuilder(UniqueTransactionIdentifier2Choice__2.builder()
				.setUnqTxIdr(MapperS.of(drrReport).<String>map("getUti", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getUti()).get())
				.setPrtry(GenericIdentification175__3.builder()
					.setId(MapperS.of(drrReport).<String>map("getUtiProprietary", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getUtiProprietary()).get())
					.build())
				.build());
			
			return Optional.ofNullable(txId)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
