package drr.regulation.asic.rewrite.trade;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import drr.regulation.asic.rewrite.trade.meta.OtherPaymentReportMeta;
import drr.regulation.common.PartyIdentifierFormatEnum;
import java.math.BigDecimal;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version 5.50.0
 */
@RosettaDataType(value="OtherPaymentReport", builder=OtherPaymentReport.OtherPaymentReportBuilderImpl.class, version="5.50.0")
@RuneDataType(value="OtherPaymentReport", model="drr", builder=OtherPaymentReport.OtherPaymentReportBuilderImpl.class, version="5.50.0")
public interface OtherPaymentReport extends RosettaModelObject {

	OtherPaymentReportMeta metaData = new OtherPaymentReportMeta();

	/*********************** Getter Methods  ***********************/
	String getPaymentType();
	BigDecimal getAmount();
	ISOCurrencyCodeEnum getCurrency();
	Date getDate();
	String getPayer();
	PartyIdentifierFormatEnum getPayerFormat();
	String getReceiver();
	PartyIdentifierFormatEnum getReceiverFormat();

	/*********************** Build Methods  ***********************/
	OtherPaymentReport build();
	
	OtherPaymentReport.OtherPaymentReportBuilder toBuilder();
	
	static OtherPaymentReport.OtherPaymentReportBuilder builder() {
		return new OtherPaymentReport.OtherPaymentReportBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends OtherPaymentReport> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends OtherPaymentReport> getType() {
		return OtherPaymentReport.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("paymentType"), String.class, getPaymentType(), this);
		processor.processBasic(path.newSubPath("amount"), BigDecimal.class, getAmount(), this);
		processor.processBasic(path.newSubPath("currency"), ISOCurrencyCodeEnum.class, getCurrency(), this);
		processor.processBasic(path.newSubPath("date"), Date.class, getDate(), this);
		processor.processBasic(path.newSubPath("payer"), String.class, getPayer(), this);
		processor.processBasic(path.newSubPath("payerFormat"), PartyIdentifierFormatEnum.class, getPayerFormat(), this);
		processor.processBasic(path.newSubPath("receiver"), String.class, getReceiver(), this);
		processor.processBasic(path.newSubPath("receiverFormat"), PartyIdentifierFormatEnum.class, getReceiverFormat(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface OtherPaymentReportBuilder extends OtherPaymentReport, RosettaModelObjectBuilder {
		OtherPaymentReport.OtherPaymentReportBuilder setPaymentType(String paymentType);
		OtherPaymentReport.OtherPaymentReportBuilder setAmount(BigDecimal amount);
		OtherPaymentReport.OtherPaymentReportBuilder setCurrency(ISOCurrencyCodeEnum currency);
		OtherPaymentReport.OtherPaymentReportBuilder setDate(Date date);
		OtherPaymentReport.OtherPaymentReportBuilder setPayer(String payer);
		OtherPaymentReport.OtherPaymentReportBuilder setPayerFormat(PartyIdentifierFormatEnum payerFormat);
		OtherPaymentReport.OtherPaymentReportBuilder setReceiver(String receiver);
		OtherPaymentReport.OtherPaymentReportBuilder setReceiverFormat(PartyIdentifierFormatEnum receiverFormat);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("paymentType"), String.class, getPaymentType(), this);
			processor.processBasic(path.newSubPath("amount"), BigDecimal.class, getAmount(), this);
			processor.processBasic(path.newSubPath("currency"), ISOCurrencyCodeEnum.class, getCurrency(), this);
			processor.processBasic(path.newSubPath("date"), Date.class, getDate(), this);
			processor.processBasic(path.newSubPath("payer"), String.class, getPayer(), this);
			processor.processBasic(path.newSubPath("payerFormat"), PartyIdentifierFormatEnum.class, getPayerFormat(), this);
			processor.processBasic(path.newSubPath("receiver"), String.class, getReceiver(), this);
			processor.processBasic(path.newSubPath("receiverFormat"), PartyIdentifierFormatEnum.class, getReceiverFormat(), this);
		}
		

		OtherPaymentReport.OtherPaymentReportBuilder prune();
	}

	/*********************** Immutable Implementation of OtherPaymentReport  ***********************/
	class OtherPaymentReportImpl implements OtherPaymentReport {
		private final String paymentType;
		private final BigDecimal amount;
		private final ISOCurrencyCodeEnum currency;
		private final Date date;
		private final String payer;
		private final PartyIdentifierFormatEnum payerFormat;
		private final String receiver;
		private final PartyIdentifierFormatEnum receiverFormat;
		
		protected OtherPaymentReportImpl(OtherPaymentReport.OtherPaymentReportBuilder builder) {
			this.paymentType = builder.getPaymentType();
			this.amount = builder.getAmount();
			this.currency = builder.getCurrency();
			this.date = builder.getDate();
			this.payer = builder.getPayer();
			this.payerFormat = builder.getPayerFormat();
			this.receiver = builder.getReceiver();
			this.receiverFormat = builder.getReceiverFormat();
		}
		
		@Override
		@RosettaAttribute("paymentType")
		@RuneAttribute("paymentType")
		public String getPaymentType() {
			return paymentType;
		}
		
		@Override
		@RosettaAttribute("amount")
		@RuneAttribute("amount")
		public BigDecimal getAmount() {
			return amount;
		}
		
		@Override
		@RosettaAttribute("currency")
		@RuneAttribute("currency")
		public ISOCurrencyCodeEnum getCurrency() {
			return currency;
		}
		
		@Override
		@RosettaAttribute("date")
		@RuneAttribute("date")
		public Date getDate() {
			return date;
		}
		
		@Override
		@RosettaAttribute("payer")
		@RuneAttribute("payer")
		public String getPayer() {
			return payer;
		}
		
		@Override
		@RosettaAttribute("payerFormat")
		@RuneAttribute("payerFormat")
		public PartyIdentifierFormatEnum getPayerFormat() {
			return payerFormat;
		}
		
		@Override
		@RosettaAttribute("receiver")
		@RuneAttribute("receiver")
		public String getReceiver() {
			return receiver;
		}
		
		@Override
		@RosettaAttribute("receiverFormat")
		@RuneAttribute("receiverFormat")
		public PartyIdentifierFormatEnum getReceiverFormat() {
			return receiverFormat;
		}
		
		@Override
		public OtherPaymentReport build() {
			return this;
		}
		
		@Override
		public OtherPaymentReport.OtherPaymentReportBuilder toBuilder() {
			OtherPaymentReport.OtherPaymentReportBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(OtherPaymentReport.OtherPaymentReportBuilder builder) {
			ofNullable(getPaymentType()).ifPresent(builder::setPaymentType);
			ofNullable(getAmount()).ifPresent(builder::setAmount);
			ofNullable(getCurrency()).ifPresent(builder::setCurrency);
			ofNullable(getDate()).ifPresent(builder::setDate);
			ofNullable(getPayer()).ifPresent(builder::setPayer);
			ofNullable(getPayerFormat()).ifPresent(builder::setPayerFormat);
			ofNullable(getReceiver()).ifPresent(builder::setReceiver);
			ofNullable(getReceiverFormat()).ifPresent(builder::setReceiverFormat);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			OtherPaymentReport _that = getType().cast(o);
		
			if (!Objects.equals(paymentType, _that.getPaymentType())) return false;
			if (!Objects.equals(amount, _that.getAmount())) return false;
			if (!Objects.equals(currency, _that.getCurrency())) return false;
			if (!Objects.equals(date, _that.getDate())) return false;
			if (!Objects.equals(payer, _that.getPayer())) return false;
			if (!Objects.equals(payerFormat, _that.getPayerFormat())) return false;
			if (!Objects.equals(receiver, _that.getReceiver())) return false;
			if (!Objects.equals(receiverFormat, _that.getReceiverFormat())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (paymentType != null ? paymentType.hashCode() : 0);
			_result = 31 * _result + (amount != null ? amount.hashCode() : 0);
			_result = 31 * _result + (currency != null ? currency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (date != null ? date.hashCode() : 0);
			_result = 31 * _result + (payer != null ? payer.hashCode() : 0);
			_result = 31 * _result + (payerFormat != null ? payerFormat.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (receiver != null ? receiver.hashCode() : 0);
			_result = 31 * _result + (receiverFormat != null ? receiverFormat.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "OtherPaymentReport {" +
				"paymentType=" + this.paymentType + ", " +
				"amount=" + this.amount + ", " +
				"currency=" + this.currency + ", " +
				"date=" + this.date + ", " +
				"payer=" + this.payer + ", " +
				"payerFormat=" + this.payerFormat + ", " +
				"receiver=" + this.receiver + ", " +
				"receiverFormat=" + this.receiverFormat +
			'}';
		}
	}

	/*********************** Builder Implementation of OtherPaymentReport  ***********************/
	class OtherPaymentReportBuilderImpl implements OtherPaymentReport.OtherPaymentReportBuilder {
	
		protected String paymentType;
		protected BigDecimal amount;
		protected ISOCurrencyCodeEnum currency;
		protected Date date;
		protected String payer;
		protected PartyIdentifierFormatEnum payerFormat;
		protected String receiver;
		protected PartyIdentifierFormatEnum receiverFormat;
		
		@Override
		@RosettaAttribute("paymentType")
		@RuneAttribute("paymentType")
		public String getPaymentType() {
			return paymentType;
		}
		
		@Override
		@RosettaAttribute("amount")
		@RuneAttribute("amount")
		public BigDecimal getAmount() {
			return amount;
		}
		
		@Override
		@RosettaAttribute("currency")
		@RuneAttribute("currency")
		public ISOCurrencyCodeEnum getCurrency() {
			return currency;
		}
		
		@Override
		@RosettaAttribute("date")
		@RuneAttribute("date")
		public Date getDate() {
			return date;
		}
		
		@Override
		@RosettaAttribute("payer")
		@RuneAttribute("payer")
		public String getPayer() {
			return payer;
		}
		
		@Override
		@RosettaAttribute("payerFormat")
		@RuneAttribute("payerFormat")
		public PartyIdentifierFormatEnum getPayerFormat() {
			return payerFormat;
		}
		
		@Override
		@RosettaAttribute("receiver")
		@RuneAttribute("receiver")
		public String getReceiver() {
			return receiver;
		}
		
		@Override
		@RosettaAttribute("receiverFormat")
		@RuneAttribute("receiverFormat")
		public PartyIdentifierFormatEnum getReceiverFormat() {
			return receiverFormat;
		}
		
		@RosettaAttribute("paymentType")
		@RuneAttribute("paymentType")
		@Override
		public OtherPaymentReport.OtherPaymentReportBuilder setPaymentType(String _paymentType) {
			this.paymentType = _paymentType == null ? null : _paymentType;
			return this;
		}
		
		@RosettaAttribute("amount")
		@RuneAttribute("amount")
		@Override
		public OtherPaymentReport.OtherPaymentReportBuilder setAmount(BigDecimal _amount) {
			this.amount = _amount == null ? null : _amount;
			return this;
		}
		
		@RosettaAttribute("currency")
		@RuneAttribute("currency")
		@Override
		public OtherPaymentReport.OtherPaymentReportBuilder setCurrency(ISOCurrencyCodeEnum _currency) {
			this.currency = _currency == null ? null : _currency;
			return this;
		}
		
		@RosettaAttribute("date")
		@RuneAttribute("date")
		@Override
		public OtherPaymentReport.OtherPaymentReportBuilder setDate(Date _date) {
			this.date = _date == null ? null : _date;
			return this;
		}
		
		@RosettaAttribute("payer")
		@RuneAttribute("payer")
		@Override
		public OtherPaymentReport.OtherPaymentReportBuilder setPayer(String _payer) {
			this.payer = _payer == null ? null : _payer;
			return this;
		}
		
		@RosettaAttribute("payerFormat")
		@RuneAttribute("payerFormat")
		@Override
		public OtherPaymentReport.OtherPaymentReportBuilder setPayerFormat(PartyIdentifierFormatEnum _payerFormat) {
			this.payerFormat = _payerFormat == null ? null : _payerFormat;
			return this;
		}
		
		@RosettaAttribute("receiver")
		@RuneAttribute("receiver")
		@Override
		public OtherPaymentReport.OtherPaymentReportBuilder setReceiver(String _receiver) {
			this.receiver = _receiver == null ? null : _receiver;
			return this;
		}
		
		@RosettaAttribute("receiverFormat")
		@RuneAttribute("receiverFormat")
		@Override
		public OtherPaymentReport.OtherPaymentReportBuilder setReceiverFormat(PartyIdentifierFormatEnum _receiverFormat) {
			this.receiverFormat = _receiverFormat == null ? null : _receiverFormat;
			return this;
		}
		
		@Override
		public OtherPaymentReport build() {
			return new OtherPaymentReport.OtherPaymentReportImpl(this);
		}
		
		@Override
		public OtherPaymentReport.OtherPaymentReportBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public OtherPaymentReport.OtherPaymentReportBuilder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getPaymentType()!=null) return true;
			if (getAmount()!=null) return true;
			if (getCurrency()!=null) return true;
			if (getDate()!=null) return true;
			if (getPayer()!=null) return true;
			if (getPayerFormat()!=null) return true;
			if (getReceiver()!=null) return true;
			if (getReceiverFormat()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public OtherPaymentReport.OtherPaymentReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			OtherPaymentReport.OtherPaymentReportBuilder o = (OtherPaymentReport.OtherPaymentReportBuilder) other;
			
			
			merger.mergeBasic(getPaymentType(), o.getPaymentType(), this::setPaymentType);
			merger.mergeBasic(getAmount(), o.getAmount(), this::setAmount);
			merger.mergeBasic(getCurrency(), o.getCurrency(), this::setCurrency);
			merger.mergeBasic(getDate(), o.getDate(), this::setDate);
			merger.mergeBasic(getPayer(), o.getPayer(), this::setPayer);
			merger.mergeBasic(getPayerFormat(), o.getPayerFormat(), this::setPayerFormat);
			merger.mergeBasic(getReceiver(), o.getReceiver(), this::setReceiver);
			merger.mergeBasic(getReceiverFormat(), o.getReceiverFormat(), this::setReceiverFormat);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			OtherPaymentReport _that = getType().cast(o);
		
			if (!Objects.equals(paymentType, _that.getPaymentType())) return false;
			if (!Objects.equals(amount, _that.getAmount())) return false;
			if (!Objects.equals(currency, _that.getCurrency())) return false;
			if (!Objects.equals(date, _that.getDate())) return false;
			if (!Objects.equals(payer, _that.getPayer())) return false;
			if (!Objects.equals(payerFormat, _that.getPayerFormat())) return false;
			if (!Objects.equals(receiver, _that.getReceiver())) return false;
			if (!Objects.equals(receiverFormat, _that.getReceiverFormat())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (paymentType != null ? paymentType.hashCode() : 0);
			_result = 31 * _result + (amount != null ? amount.hashCode() : 0);
			_result = 31 * _result + (currency != null ? currency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (date != null ? date.hashCode() : 0);
			_result = 31 * _result + (payer != null ? payer.hashCode() : 0);
			_result = 31 * _result + (payerFormat != null ? payerFormat.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (receiver != null ? receiver.hashCode() : 0);
			_result = 31 * _result + (receiverFormat != null ? receiverFormat.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "OtherPaymentReportBuilder {" +
				"paymentType=" + this.paymentType + ", " +
				"amount=" + this.amount + ", " +
				"currency=" + this.currency + ", " +
				"date=" + this.date + ", " +
				"payer=" + this.payer + ", " +
				"payerFormat=" + this.payerFormat + ", " +
				"receiver=" + this.receiver + ", " +
				"receiverFormat=" + this.receiverFormat +
			'}';
		}
	}
}
