package drr.regulation.asic.rewrite.trade;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.regulation.asic.rewrite.trade.meta.SpreadLeg2Meta;
import drr.standards.iso.PriceNotationEnum;
import java.math.BigDecimal;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version 5.50.0
 */
@RosettaDataType(value="SpreadLeg2", builder=SpreadLeg2.SpreadLeg2BuilderImpl.class, version="5.50.0")
@RuneDataType(value="SpreadLeg2", model="drr", builder=SpreadLeg2.SpreadLeg2BuilderImpl.class, version="5.50.0")
public interface SpreadLeg2 extends RosettaModelObject {

	SpreadLeg2Meta metaData = new SpreadLeg2Meta();

	/*********************** Getter Methods  ***********************/
	BigDecimal getSpreadLeg2Monetary();
	BigDecimal getSpreadLeg2Decimal();
	BigDecimal getSpreadLeg2Basis();
	PriceNotationEnum getSpreadLeg2Notation();

	/*********************** Build Methods  ***********************/
	SpreadLeg2 build();
	
	SpreadLeg2.SpreadLeg2Builder toBuilder();
	
	static SpreadLeg2.SpreadLeg2Builder builder() {
		return new SpreadLeg2.SpreadLeg2BuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends SpreadLeg2> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends SpreadLeg2> getType() {
		return SpreadLeg2.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("spreadLeg2Monetary"), BigDecimal.class, getSpreadLeg2Monetary(), this);
		processor.processBasic(path.newSubPath("spreadLeg2Decimal"), BigDecimal.class, getSpreadLeg2Decimal(), this);
		processor.processBasic(path.newSubPath("spreadLeg2Basis"), BigDecimal.class, getSpreadLeg2Basis(), this);
		processor.processBasic(path.newSubPath("spreadLeg2Notation"), PriceNotationEnum.class, getSpreadLeg2Notation(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface SpreadLeg2Builder extends SpreadLeg2, RosettaModelObjectBuilder {
		SpreadLeg2.SpreadLeg2Builder setSpreadLeg2Monetary(BigDecimal spreadLeg2Monetary);
		SpreadLeg2.SpreadLeg2Builder setSpreadLeg2Decimal(BigDecimal spreadLeg2Decimal);
		SpreadLeg2.SpreadLeg2Builder setSpreadLeg2Basis(BigDecimal spreadLeg2Basis);
		SpreadLeg2.SpreadLeg2Builder setSpreadLeg2Notation(PriceNotationEnum spreadLeg2Notation);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("spreadLeg2Monetary"), BigDecimal.class, getSpreadLeg2Monetary(), this);
			processor.processBasic(path.newSubPath("spreadLeg2Decimal"), BigDecimal.class, getSpreadLeg2Decimal(), this);
			processor.processBasic(path.newSubPath("spreadLeg2Basis"), BigDecimal.class, getSpreadLeg2Basis(), this);
			processor.processBasic(path.newSubPath("spreadLeg2Notation"), PriceNotationEnum.class, getSpreadLeg2Notation(), this);
		}
		

		SpreadLeg2.SpreadLeg2Builder prune();
	}

	/*********************** Immutable Implementation of SpreadLeg2  ***********************/
	class SpreadLeg2Impl implements SpreadLeg2 {
		private final BigDecimal spreadLeg2Monetary;
		private final BigDecimal spreadLeg2Decimal;
		private final BigDecimal spreadLeg2Basis;
		private final PriceNotationEnum spreadLeg2Notation;
		
		protected SpreadLeg2Impl(SpreadLeg2.SpreadLeg2Builder builder) {
			this.spreadLeg2Monetary = builder.getSpreadLeg2Monetary();
			this.spreadLeg2Decimal = builder.getSpreadLeg2Decimal();
			this.spreadLeg2Basis = builder.getSpreadLeg2Basis();
			this.spreadLeg2Notation = builder.getSpreadLeg2Notation();
		}
		
		@Override
		@RosettaAttribute("spreadLeg2Monetary")
		@RuneAttribute("spreadLeg2Monetary")
		public BigDecimal getSpreadLeg2Monetary() {
			return spreadLeg2Monetary;
		}
		
		@Override
		@RosettaAttribute("spreadLeg2Decimal")
		@RuneAttribute("spreadLeg2Decimal")
		public BigDecimal getSpreadLeg2Decimal() {
			return spreadLeg2Decimal;
		}
		
		@Override
		@RosettaAttribute("spreadLeg2Basis")
		@RuneAttribute("spreadLeg2Basis")
		public BigDecimal getSpreadLeg2Basis() {
			return spreadLeg2Basis;
		}
		
		@Override
		@RosettaAttribute("spreadLeg2Notation")
		@RuneAttribute("spreadLeg2Notation")
		public PriceNotationEnum getSpreadLeg2Notation() {
			return spreadLeg2Notation;
		}
		
		@Override
		public SpreadLeg2 build() {
			return this;
		}
		
		@Override
		public SpreadLeg2.SpreadLeg2Builder toBuilder() {
			SpreadLeg2.SpreadLeg2Builder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(SpreadLeg2.SpreadLeg2Builder builder) {
			ofNullable(getSpreadLeg2Monetary()).ifPresent(builder::setSpreadLeg2Monetary);
			ofNullable(getSpreadLeg2Decimal()).ifPresent(builder::setSpreadLeg2Decimal);
			ofNullable(getSpreadLeg2Basis()).ifPresent(builder::setSpreadLeg2Basis);
			ofNullable(getSpreadLeg2Notation()).ifPresent(builder::setSpreadLeg2Notation);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			SpreadLeg2 _that = getType().cast(o);
		
			if (!Objects.equals(spreadLeg2Monetary, _that.getSpreadLeg2Monetary())) return false;
			if (!Objects.equals(spreadLeg2Decimal, _that.getSpreadLeg2Decimal())) return false;
			if (!Objects.equals(spreadLeg2Basis, _that.getSpreadLeg2Basis())) return false;
			if (!Objects.equals(spreadLeg2Notation, _that.getSpreadLeg2Notation())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (spreadLeg2Monetary != null ? spreadLeg2Monetary.hashCode() : 0);
			_result = 31 * _result + (spreadLeg2Decimal != null ? spreadLeg2Decimal.hashCode() : 0);
			_result = 31 * _result + (spreadLeg2Basis != null ? spreadLeg2Basis.hashCode() : 0);
			_result = 31 * _result + (spreadLeg2Notation != null ? spreadLeg2Notation.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "SpreadLeg2 {" +
				"spreadLeg2Monetary=" + this.spreadLeg2Monetary + ", " +
				"spreadLeg2Decimal=" + this.spreadLeg2Decimal + ", " +
				"spreadLeg2Basis=" + this.spreadLeg2Basis + ", " +
				"spreadLeg2Notation=" + this.spreadLeg2Notation +
			'}';
		}
	}

	/*********************** Builder Implementation of SpreadLeg2  ***********************/
	class SpreadLeg2BuilderImpl implements SpreadLeg2.SpreadLeg2Builder {
	
		protected BigDecimal spreadLeg2Monetary;
		protected BigDecimal spreadLeg2Decimal;
		protected BigDecimal spreadLeg2Basis;
		protected PriceNotationEnum spreadLeg2Notation;
		
		@Override
		@RosettaAttribute("spreadLeg2Monetary")
		@RuneAttribute("spreadLeg2Monetary")
		public BigDecimal getSpreadLeg2Monetary() {
			return spreadLeg2Monetary;
		}
		
		@Override
		@RosettaAttribute("spreadLeg2Decimal")
		@RuneAttribute("spreadLeg2Decimal")
		public BigDecimal getSpreadLeg2Decimal() {
			return spreadLeg2Decimal;
		}
		
		@Override
		@RosettaAttribute("spreadLeg2Basis")
		@RuneAttribute("spreadLeg2Basis")
		public BigDecimal getSpreadLeg2Basis() {
			return spreadLeg2Basis;
		}
		
		@Override
		@RosettaAttribute("spreadLeg2Notation")
		@RuneAttribute("spreadLeg2Notation")
		public PriceNotationEnum getSpreadLeg2Notation() {
			return spreadLeg2Notation;
		}
		
		@RosettaAttribute("spreadLeg2Monetary")
		@RuneAttribute("spreadLeg2Monetary")
		@Override
		public SpreadLeg2.SpreadLeg2Builder setSpreadLeg2Monetary(BigDecimal _spreadLeg2Monetary) {
			this.spreadLeg2Monetary = _spreadLeg2Monetary == null ? null : _spreadLeg2Monetary;
			return this;
		}
		
		@RosettaAttribute("spreadLeg2Decimal")
		@RuneAttribute("spreadLeg2Decimal")
		@Override
		public SpreadLeg2.SpreadLeg2Builder setSpreadLeg2Decimal(BigDecimal _spreadLeg2Decimal) {
			this.spreadLeg2Decimal = _spreadLeg2Decimal == null ? null : _spreadLeg2Decimal;
			return this;
		}
		
		@RosettaAttribute("spreadLeg2Basis")
		@RuneAttribute("spreadLeg2Basis")
		@Override
		public SpreadLeg2.SpreadLeg2Builder setSpreadLeg2Basis(BigDecimal _spreadLeg2Basis) {
			this.spreadLeg2Basis = _spreadLeg2Basis == null ? null : _spreadLeg2Basis;
			return this;
		}
		
		@RosettaAttribute("spreadLeg2Notation")
		@RuneAttribute("spreadLeg2Notation")
		@Override
		public SpreadLeg2.SpreadLeg2Builder setSpreadLeg2Notation(PriceNotationEnum _spreadLeg2Notation) {
			this.spreadLeg2Notation = _spreadLeg2Notation == null ? null : _spreadLeg2Notation;
			return this;
		}
		
		@Override
		public SpreadLeg2 build() {
			return new SpreadLeg2.SpreadLeg2Impl(this);
		}
		
		@Override
		public SpreadLeg2.SpreadLeg2Builder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public SpreadLeg2.SpreadLeg2Builder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getSpreadLeg2Monetary()!=null) return true;
			if (getSpreadLeg2Decimal()!=null) return true;
			if (getSpreadLeg2Basis()!=null) return true;
			if (getSpreadLeg2Notation()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public SpreadLeg2.SpreadLeg2Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			SpreadLeg2.SpreadLeg2Builder o = (SpreadLeg2.SpreadLeg2Builder) other;
			
			
			merger.mergeBasic(getSpreadLeg2Monetary(), o.getSpreadLeg2Monetary(), this::setSpreadLeg2Monetary);
			merger.mergeBasic(getSpreadLeg2Decimal(), o.getSpreadLeg2Decimal(), this::setSpreadLeg2Decimal);
			merger.mergeBasic(getSpreadLeg2Basis(), o.getSpreadLeg2Basis(), this::setSpreadLeg2Basis);
			merger.mergeBasic(getSpreadLeg2Notation(), o.getSpreadLeg2Notation(), this::setSpreadLeg2Notation);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			SpreadLeg2 _that = getType().cast(o);
		
			if (!Objects.equals(spreadLeg2Monetary, _that.getSpreadLeg2Monetary())) return false;
			if (!Objects.equals(spreadLeg2Decimal, _that.getSpreadLeg2Decimal())) return false;
			if (!Objects.equals(spreadLeg2Basis, _that.getSpreadLeg2Basis())) return false;
			if (!Objects.equals(spreadLeg2Notation, _that.getSpreadLeg2Notation())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (spreadLeg2Monetary != null ? spreadLeg2Monetary.hashCode() : 0);
			_result = 31 * _result + (spreadLeg2Decimal != null ? spreadLeg2Decimal.hashCode() : 0);
			_result = 31 * _result + (spreadLeg2Basis != null ? spreadLeg2Basis.hashCode() : 0);
			_result = 31 * _result + (spreadLeg2Notation != null ? spreadLeg2Notation.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "SpreadLeg2Builder {" +
				"spreadLeg2Monetary=" + this.spreadLeg2Monetary + ", " +
				"spreadLeg2Decimal=" + this.spreadLeg2Decimal + ", " +
				"spreadLeg2Basis=" + this.spreadLeg2Basis + ", " +
				"spreadLeg2Notation=" + this.spreadLeg2Notation +
			'}';
		}
	}
}
