package drr.regulation.asic.rewrite.trade.meta;

import com.rosetta.model.lib.annotations.RosettaMeta;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.qualify.QualifyFunctionFactory;
import com.rosetta.model.lib.qualify.QualifyResult;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.lib.validation.ValidatorFactory;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.asic.rewrite.trade.ASICCustomBasket;
import drr.regulation.asic.rewrite.trade.validation.ASICCustomBasketTypeFormatValidator;
import drr.regulation.asic.rewrite.trade.validation.ASICCustomBasketValidator;
import drr.regulation.asic.rewrite.trade.validation.exists.ASICCustomBasketOnlyExistsValidator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;


/**
 * @version 5.50.0
 */
@RosettaMeta(model=ASICCustomBasket.class)
public class ASICCustomBasketMeta implements RosettaMetaData<ASICCustomBasket> {

	@Override
	public List<Validator<? super ASICCustomBasket>> dataRules(ValidatorFactory factory) {
		return Arrays.asList(
		);
	}
	
	@Override
	public List<Function<? super ASICCustomBasket, QualifyResult>> getQualifyFunctions(QualifyFunctionFactory factory) {
		return Collections.emptyList();
	}
	
	@Override
	public Validator<? super ASICCustomBasket> validator(ValidatorFactory factory) {
		return factory.<ASICCustomBasket>create(ASICCustomBasketValidator.class);
	}

	@Override
	public Validator<? super ASICCustomBasket> typeFormatValidator(ValidatorFactory factory) {
		return factory.<ASICCustomBasket>create(ASICCustomBasketTypeFormatValidator.class);
	}

	@Deprecated
	@Override
	public Validator<? super ASICCustomBasket> validator() {
		return new ASICCustomBasketValidator();
	}

	@Deprecated
	@Override
	public Validator<? super ASICCustomBasket> typeFormatValidator() {
		return new ASICCustomBasketTypeFormatValidator();
	}
	
	@Override
	public ValidatorWithArg<? super ASICCustomBasket, Set<String>> onlyExistsValidator() {
		return new ASICCustomBasketOnlyExistsValidator();
	}
}
