package drr.regulation.asic.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.asic.rewrite.trade.functions.IsAllowableActionForASIC;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.GetContractType;
import drr.standards.iosco.cde.reports.CDEOptionPremiumAmountRule;
import java.math.BigDecimal;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(OptionPremiumAmountRule.OptionPremiumAmountRuleDefault.class)
public abstract class OptionPremiumAmountRule implements ReportFunction<TransactionReportInstruction, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDEOptionPremiumAmountRule cDEOptionPremiumAmountRule;
	@Inject protected GetContractType getContractType;
	@Inject protected IsAllowableActionForASIC isAllowableActionForASIC;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(TransactionReportInstruction input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(TransactionReportInstruction input);

	public static class OptionPremiumAmountRuleDefault extends OptionPremiumAmountRule {
		@Override
		protected BigDecimal doEvaluate(TransactionReportInstruction input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForASIC.evaluate(item.get()));
			final MapperS<BigDecimal> ifThenElseResult;
			if (areEqual(MapperS.of(getContractType.evaluate(thenArg.get())), MapperS.of("OPTN"), CardinalityOperator.All).and(notExists(MapperS.of(cDEOptionPremiumAmountRule.evaluate(thenArg.get())))).getOrDefault(false)) {
				ifThenElseResult = MapperS.of(BigDecimal.valueOf(0));
			} else {
				ifThenElseResult = MapperS.of(cDEOptionPremiumAmountRule.evaluate(thenArg.get()));
			}
			output = ifThenElseResult.get();
			
			return output;
		}
	}
}
