package drr.regulation.asic.rewrite.trade.reports;

import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.metafields.ReferenceWithMetaPriceSchedule;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.asic.rewrite.trade.functions.IsAllowableActionForASIC;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.FormatToBaseOneRate;
import drr.regulation.common.functions.GetPriceNotation;
import drr.regulation.common.functions.MultiplyPrice;
import drr.standards.iosco.cde.reports.CDESpreadLeg1Rule;
import drr.standards.iso.PriceNotationEnum;
import java.math.BigDecimal;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(SpreadLeg1DecimalRule.SpreadLeg1DecimalRuleDefault.class)
public abstract class SpreadLeg1DecimalRule implements ReportFunction<TransactionReportInstruction, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDESpreadLeg1Rule cDESpreadLeg1Rule;
	@Inject protected FormatToBaseOneRate formatToBaseOneRate;
	@Inject protected GetPriceNotation getPriceNotation;
	@Inject protected IsAllowableActionForASIC isAllowableActionForASIC;
	@Inject protected MultiplyPrice multiplyPrice;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(TransactionReportInstruction input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(TransactionReportInstruction input);

	public static class SpreadLeg1DecimalRuleDefault extends SpreadLeg1DecimalRule {
		@Override
		protected BigDecimal doEvaluate(TransactionReportInstruction input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForASIC.evaluate(item.get()));
			final MapperS<ReferenceWithMetaPriceSchedule> thenArg1 = thenArg0
				.mapSingleToItem(item -> {
					final PriceSchedule priceSchedule = cDESpreadLeg1Rule.evaluate(item.get());
					return priceSchedule == null ? MapperS.<ReferenceWithMetaPriceSchedule>ofNull() : MapperS.of(ReferenceWithMetaPriceSchedule.builder().setValue(priceSchedule).build());
				});
			final MapperS<BigDecimal> thenArg2 = thenArg1
				.mapSingleToItem(item -> {
					final ReferenceWithMetaPriceSchedule referenceWithMetaPriceSchedule0 = item.get();
					final ReferenceWithMetaPriceSchedule referenceWithMetaPriceSchedule1 = item.get();
					if (areEqual(MapperS.of(getPriceNotation.evaluate((referenceWithMetaPriceSchedule0 == null ? null : referenceWithMetaPriceSchedule0.getValue()))), MapperS.of(PriceNotationEnum.PERCENTAGE), CardinalityOperator.All).or(areEqual(MapperS.of(getPriceNotation.evaluate((referenceWithMetaPriceSchedule1 == null ? null : referenceWithMetaPriceSchedule1.getValue()))), MapperS.of(PriceNotationEnum.DECIMAL), CardinalityOperator.All)).getOrDefault(false)) {
						return MapperS.of(multiplyPrice.evaluate(item.<PriceSchedule>map("Type coercion", referenceWithMetaPriceSchedule2 -> referenceWithMetaPriceSchedule2 == null ? null : referenceWithMetaPriceSchedule2.getValue()).<BigDecimal>map("getValue", priceSchedule -> priceSchedule.getValue()).get(), PriceNotationEnum.DECIMAL));
					}
					return MapperS.<BigDecimal>ofNull();
				});
			output = MapperS.of(formatToBaseOneRate.evaluate(thenArg2.get())).get();
			
			return output;
		}
	}
}
