package drr.regulation.asic.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.asic.rewrite.trade.ASICTransactionReport;
import drr.regulation.asic.rewrite.trade.OtherPaymentReport;
import drr.regulation.asic.rewrite.trade.PriceAndNotation;
import drr.regulation.asic.rewrite.trade.SpreadLeg1;
import drr.regulation.asic.rewrite.trade.SpreadLeg2;
import drr.regulation.asic.rewrite.trade.StrikePriceAndNotation;
import drr.regulation.common.ActionTypeEnum;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.50.0
 */
@RosettaDataRule("ASICTransactionReportDTCC_ASIC_BR_1047_03")
@ImplementedBy(ASICTransactionReportDTCC_ASIC_BR_1047_03.Default.class)
public interface ASICTransactionReportDTCC_ASIC_BR_1047_03 extends Validator<ASICTransactionReport> {
	
	String NAME = "ASICTransactionReportDTCC_ASIC_BR_1047_03";
	String DEFINITION = "if [ ActionTypeEnum -> NEWT to-string, ActionTypeEnum -> MODI to-string, ActionTypeEnum -> CORR to-string, ActionTypeEnum -> REVI to-string ] any = actionType and (\"CRDT\" = assetClass and [\"FRAS\", \"FORW\", \"OPTN\", \"SWAP\", \"SWPT\", \"OTHR\"] any = contractType) then if fixedRateLeg1 is absent and fixedRateLeg2 is absent and spreadLeg1 is absent and spreadLeg2 is absent and strikePrice is absent and optionPremiumAmount is absent and otherPayment -> paymentType any <> \"UFRO\" then price exists";
	
	class Default implements ASICTransactionReportDTCC_ASIC_BR_1047_03 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ASICTransactionReport aSICTransactionReport) {
			ComparisonResult result = executeDataRule(aSICTransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "ASICTransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "ASICTransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(ASICTransactionReport aSICTransactionReport) {
			try {
				if (areEqual(MapperC.<String>of(MapperS.of(ActionTypeEnum.NEWT).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.MODI).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.CORR).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.REVI).map("to-string", ActionTypeEnum::toDisplayString)), MapperS.of(aSICTransactionReport).<String>map("getActionType", _aSICTransactionReport -> _aSICTransactionReport.getActionType()), CardinalityOperator.Any).and(areEqual(MapperS.of("CRDT"), MapperS.of(aSICTransactionReport).<String>map("getAssetClass", _aSICTransactionReport -> _aSICTransactionReport.getAssetClass()), CardinalityOperator.All).and(areEqual(MapperC.<String>of(MapperS.of("FRAS"), MapperS.of("FORW"), MapperS.of("OPTN"), MapperS.of("SWAP"), MapperS.of("SWPT"), MapperS.of("OTHR")), MapperS.of(aSICTransactionReport).<String>map("getContractType", _aSICTransactionReport -> _aSICTransactionReport.getContractType()), CardinalityOperator.Any))).getOrDefault(false)) {
					if (notExists(MapperS.of(aSICTransactionReport).<BigDecimal>map("getFixedRateLeg1", _aSICTransactionReport -> _aSICTransactionReport.getFixedRateLeg1())).and(notExists(MapperS.of(aSICTransactionReport).<BigDecimal>map("getFixedRateLeg2", _aSICTransactionReport -> _aSICTransactionReport.getFixedRateLeg2()))).and(notExists(MapperS.of(aSICTransactionReport).<SpreadLeg1>map("getSpreadLeg1", _aSICTransactionReport -> _aSICTransactionReport.getSpreadLeg1()))).and(notExists(MapperS.of(aSICTransactionReport).<SpreadLeg2>map("getSpreadLeg2", _aSICTransactionReport -> _aSICTransactionReport.getSpreadLeg2()))).and(notExists(MapperS.of(aSICTransactionReport).<StrikePriceAndNotation>map("getStrikePrice", _aSICTransactionReport -> _aSICTransactionReport.getStrikePrice()))).and(notExists(MapperS.of(aSICTransactionReport).<BigDecimal>map("getOptionPremiumAmount", _aSICTransactionReport -> _aSICTransactionReport.getOptionPremiumAmount()))).and(notEqual(MapperS.of(aSICTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _aSICTransactionReport -> _aSICTransactionReport.getOtherPayment()).<String>map("getPaymentType", otherPaymentReport -> otherPaymentReport.getPaymentType()), MapperS.of("UFRO"), CardinalityOperator.Any)).getOrDefault(false)) {
						return exists(MapperS.of(aSICTransactionReport).<PriceAndNotation>map("getPrice", _aSICTransactionReport -> _aSICTransactionReport.getPrice()));
					}
					return ComparisonResult.successEmptyOperand("");
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements ASICTransactionReportDTCC_ASIC_BR_1047_03 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ASICTransactionReport aSICTransactionReport) {
			return Collections.emptyList();
		}
	}
}
