package drr.regulation.asic.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.asic.rewrite.trade.ASICTransactionReport;
import drr.regulation.common.ActionTypeEnum;
import drr.regulation.common.EventTypeEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.50.0
 */
@RosettaDataRule("ASICTransactionReportDTCC_ASIC_BR_1100_01")
@ImplementedBy(ASICTransactionReportDTCC_ASIC_BR_1100_01.Default.class)
public interface ASICTransactionReportDTCC_ASIC_BR_1100_01 extends Validator<ASICTransactionReport> {
	
	String NAME = "ASICTransactionReportDTCC_ASIC_BR_1100_01";
	String DEFINITION = "if [ ActionTypeEnum -> NEWT to-string, ActionTypeEnum -> MODI to-string, ActionTypeEnum -> CORR to-string, ActionTypeEnum -> REVI to-string, ActionTypeEnum -> TERM to-string ] any = actionType then if eventType = EventTypeEnum -> COMP to-string or eventType = EventTypeEnum -> CREV to-string then eventIdentifier exists";
	
	class Default implements ASICTransactionReportDTCC_ASIC_BR_1100_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ASICTransactionReport aSICTransactionReport) {
			ComparisonResult result = executeDataRule(aSICTransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "ASICTransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "ASICTransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(ASICTransactionReport aSICTransactionReport) {
			try {
				if (areEqual(MapperC.<String>of(MapperS.of(ActionTypeEnum.NEWT).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.MODI).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.CORR).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.REVI).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.TERM).map("to-string", ActionTypeEnum::toDisplayString)), MapperS.of(aSICTransactionReport).<String>map("getActionType", _aSICTransactionReport -> _aSICTransactionReport.getActionType()), CardinalityOperator.Any).getOrDefault(false)) {
					if (areEqual(MapperS.of(aSICTransactionReport).<String>map("getEventType", _aSICTransactionReport -> _aSICTransactionReport.getEventType()), MapperS.of(EventTypeEnum.COMP).map("to-string", EventTypeEnum::toDisplayString), CardinalityOperator.All).or(areEqual(MapperS.of(aSICTransactionReport).<String>map("getEventType", _aSICTransactionReport -> _aSICTransactionReport.getEventType()), MapperS.of(EventTypeEnum.CREV).map("to-string", EventTypeEnum::toDisplayString), CardinalityOperator.All)).getOrDefault(false)) {
						return exists(MapperS.of(aSICTransactionReport).<String>map("getEventIdentifier", _aSICTransactionReport -> _aSICTransactionReport.getEventIdentifier()));
					}
					return ComparisonResult.successEmptyOperand("");
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements ASICTransactionReportDTCC_ASIC_BR_1100_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ASICTransactionReport aSICTransactionReport) {
			return Collections.emptyList();
		}
	}
}
