package drr.regulation.asic.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.asic.rewrite.trade.ASICTransactionReport;
import drr.regulation.common.ActionTypeEnum;
import drr.regulation.common.EventTypeEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.50.0
 */
@RosettaDataRule("ASICTransactionReportDTCC_ASIC_BR_1102_01")
@ImplementedBy(ASICTransactionReportDTCC_ASIC_BR_1102_01.Default.class)
public interface ASICTransactionReportDTCC_ASIC_BR_1102_01 extends Validator<ASICTransactionReport> {
	
	String NAME = "ASICTransactionReportDTCC_ASIC_BR_1102_01";
	String DEFINITION = "if [ ActionTypeEnum -> NEWT to-string, ActionTypeEnum -> MODI to-string, ActionTypeEnum -> CORR to-string, ActionTypeEnum -> REVI to-string, ActionTypeEnum -> TERM to-string, ActionTypeEnum -> PRTO to-string, ActionTypeEnum -> EROR to-string, ActionTypeEnum -> MARU to-string, ActionTypeEnum -> VALU to-string ] any = actionType then if actionType = ActionTypeEnum -> NEWT to-string then [ EventTypeEnum -> TRAD to-string, EventTypeEnum -> NOVA to-string, EventTypeEnum -> COMP to-string, EventTypeEnum -> CLRG to-string, EventTypeEnum -> EXER to-string, EventTypeEnum -> ALOC to-string, EventTypeEnum -> PTNG to-string, EventTypeEnum -> CORP to-string, EventTypeEnum -> INCP to-string ] any = eventType else if actionType = ActionTypeEnum -> MODI to-string then [ EventTypeEnum -> TRAD to-string, EventTypeEnum -> NOVA to-string, EventTypeEnum -> COMP to-string, EventTypeEnum -> ETRM to-string, EventTypeEnum -> EXER to-string, EventTypeEnum -> ALOC to-string, EventTypeEnum -> CREV to-string, EventTypeEnum -> CORP to-string, EventTypeEnum -> INCP to-string, EventTypeEnum -> UPDT to-string ] any = eventType else if actionType = ActionTypeEnum -> TERM to-string then [ EventTypeEnum -> NOVA to-string, EventTypeEnum -> COMP to-string, EventTypeEnum -> ETRM to-string, EventTypeEnum -> CLRG to-string, EventTypeEnum -> EXER to-string, EventTypeEnum -> ALOC to-string, EventTypeEnum -> CREV to-string, EventTypeEnum -> CORP to-string, EventTypeEnum -> INCP to-string ] any = eventType else if actionType = ActionTypeEnum -> PRTO to-string then eventType = EventTypeEnum -> PTNG to-string";
	
	class Default implements ASICTransactionReportDTCC_ASIC_BR_1102_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ASICTransactionReport aSICTransactionReport) {
			ComparisonResult result = executeDataRule(aSICTransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "ASICTransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "ASICTransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(ASICTransactionReport aSICTransactionReport) {
			try {
				if (areEqual(MapperC.<String>of(MapperS.of(ActionTypeEnum.NEWT).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.MODI).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.CORR).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.REVI).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.TERM).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.PRTO).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.EROR).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.MARU).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.VALU).map("to-string", ActionTypeEnum::toDisplayString)), MapperS.of(aSICTransactionReport).<String>map("getActionType", _aSICTransactionReport -> _aSICTransactionReport.getActionType()), CardinalityOperator.Any).getOrDefault(false)) {
					if (areEqual(MapperS.of(aSICTransactionReport).<String>map("getActionType", _aSICTransactionReport -> _aSICTransactionReport.getActionType()), MapperS.of(ActionTypeEnum.NEWT).map("to-string", ActionTypeEnum::toDisplayString), CardinalityOperator.All).getOrDefault(false)) {
						return areEqual(MapperC.<String>of(MapperS.of(EventTypeEnum.TRAD).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.NOVA).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.COMP).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.CLRG).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.EXER).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.ALOC).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.PTNG).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.CORP).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.INCP).map("to-string", EventTypeEnum::toDisplayString)), MapperS.of(aSICTransactionReport).<String>map("getEventType", _aSICTransactionReport -> _aSICTransactionReport.getEventType()), CardinalityOperator.Any);
					}
					if (areEqual(MapperS.of(aSICTransactionReport).<String>map("getActionType", _aSICTransactionReport -> _aSICTransactionReport.getActionType()), MapperS.of(ActionTypeEnum.MODI).map("to-string", ActionTypeEnum::toDisplayString), CardinalityOperator.All).getOrDefault(false)) {
						return areEqual(MapperC.<String>of(MapperS.of(EventTypeEnum.TRAD).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.NOVA).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.COMP).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.ETRM).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.EXER).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.ALOC).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.CREV).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.CORP).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.INCP).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.UPDT).map("to-string", EventTypeEnum::toDisplayString)), MapperS.of(aSICTransactionReport).<String>map("getEventType", _aSICTransactionReport -> _aSICTransactionReport.getEventType()), CardinalityOperator.Any);
					}
					if (areEqual(MapperS.of(aSICTransactionReport).<String>map("getActionType", _aSICTransactionReport -> _aSICTransactionReport.getActionType()), MapperS.of(ActionTypeEnum.TERM).map("to-string", ActionTypeEnum::toDisplayString), CardinalityOperator.All).getOrDefault(false)) {
						return areEqual(MapperC.<String>of(MapperS.of(EventTypeEnum.NOVA).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.COMP).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.ETRM).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.CLRG).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.EXER).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.ALOC).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.CREV).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.CORP).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.INCP).map("to-string", EventTypeEnum::toDisplayString)), MapperS.of(aSICTransactionReport).<String>map("getEventType", _aSICTransactionReport -> _aSICTransactionReport.getEventType()), CardinalityOperator.Any);
					}
					if (areEqual(MapperS.of(aSICTransactionReport).<String>map("getActionType", _aSICTransactionReport -> _aSICTransactionReport.getActionType()), MapperS.of(ActionTypeEnum.PRTO).map("to-string", ActionTypeEnum::toDisplayString), CardinalityOperator.All).getOrDefault(false)) {
						return areEqual(MapperS.of(aSICTransactionReport).<String>map("getEventType", _aSICTransactionReport -> _aSICTransactionReport.getEventType()), MapperS.of(EventTypeEnum.PTNG).map("to-string", EventTypeEnum::toDisplayString), CardinalityOperator.All);
					}
					return ComparisonResult.successEmptyOperand("");
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements ASICTransactionReportDTCC_ASIC_BR_1102_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ASICTransactionReport aSICTransactionReport) {
			return Collections.emptyList();
		}
	}
}
