package drr.regulation.asic.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.asic.rewrite.trade.ASICTransactionReport;
import drr.regulation.common.ActionTypeEnum;
import drr.regulation.common.EventTypeEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.50.0
 */
@RosettaDataRule("ASICTransactionReportPriorUti")
@ImplementedBy(ASICTransactionReportPriorUti.Default.class)
public interface ASICTransactionReportPriorUti extends Validator<ASICTransactionReport> {
	
	String NAME = "ASICTransactionReportPriorUti";
	String DEFINITION = "if actionType = ActionTypeEnum -> NEWT to-string and [ EventTypeEnum -> NOVA to-string, EventTypeEnum -> EXER to-string, EventTypeEnum -> ALOC to-string, EventTypeEnum -> CLRG to-string, EventTypeEnum -> CLAL to-string ] any = eventType then required choice priorUTI, priorUtiProprietary";
	
	class Default implements ASICTransactionReportPriorUti {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ASICTransactionReport aSICTransactionReport) {
			ComparisonResult result = executeDataRule(aSICTransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "ASICTransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "ASICTransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(ASICTransactionReport aSICTransactionReport) {
			try {
				if (areEqual(MapperS.of(aSICTransactionReport).<String>map("getActionType", _aSICTransactionReport -> _aSICTransactionReport.getActionType()), MapperS.of(ActionTypeEnum.NEWT).map("to-string", ActionTypeEnum::toDisplayString), CardinalityOperator.All).and(areEqual(MapperC.<String>of(MapperS.of(EventTypeEnum.NOVA).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.EXER).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.ALOC).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.CLRG).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.CLAL).map("to-string", EventTypeEnum::toDisplayString)), MapperS.of(aSICTransactionReport).<String>map("getEventType", _aSICTransactionReport -> _aSICTransactionReport.getEventType()), CardinalityOperator.Any)).getOrDefault(false)) {
					return choice(MapperS.of(aSICTransactionReport), Arrays.asList("priorUTI", "priorUtiProprietary"), ChoiceRuleValidationMethod.REQUIRED);
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements ASICTransactionReportPriorUti {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ASICTransactionReport aSICTransactionReport) {
			return Collections.emptyList();
		}
	}
}
