package drr.regulation.asic.rewrite.trade.validation.exists;

import com.google.common.collect.ImmutableMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.asic.rewrite.trade.SpreadLeg2;
import drr.standards.iso.PriceNotationEnum;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;

public class SpreadLeg2OnlyExistsValidator implements ValidatorWithArg<SpreadLeg2, Set<String>> {

	/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
	@Override
	public <T2 extends SpreadLeg2> ValidationResult<SpreadLeg2> validate(RosettaPath path, T2 o, Set<String> fields) {
		Map<String, Boolean> fieldExistenceMap = ImmutableMap.<String, Boolean>builder()
				.put("spreadLeg2Monetary", ExistenceChecker.isSet((BigDecimal) o.getSpreadLeg2Monetary()))
				.put("spreadLeg2Decimal", ExistenceChecker.isSet((BigDecimal) o.getSpreadLeg2Decimal()))
				.put("spreadLeg2Basis", ExistenceChecker.isSet((BigDecimal) o.getSpreadLeg2Basis()))
				.put("spreadLeg2Notation", ExistenceChecker.isSet((PriceNotationEnum) o.getSpreadLeg2Notation()))
				.build();
		
		// Find the fields that are set
		Set<String> setFields = fieldExistenceMap.entrySet().stream()
				.filter(Map.Entry::getValue)
				.map(Map.Entry::getKey)
				.collect(Collectors.toSet());
		
		if (setFields.equals(fields)) {
			return success("SpreadLeg2", ValidationResult.ValidationType.ONLY_EXISTS, "SpreadLeg2", path, "");
		}
		return failure("SpreadLeg2", ValidationResult.ValidationType.ONLY_EXISTS, "SpreadLeg2", path, "",
				String.format("[%s] should only be set.  Set fields: %s", fields, setFields));
	}
}
