package drr.regulation.cftc.rewrite.meta;

import com.rosetta.model.lib.annotations.RosettaMeta;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.qualify.QualifyFunctionFactory;
import com.rosetta.model.lib.qualify.QualifyResult;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.lib.validation.ValidatorFactory;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.cftc.rewrite.OtherPaymentReport;
import drr.regulation.cftc.rewrite.validation.OtherPaymentReportTypeFormatValidator;
import drr.regulation.cftc.rewrite.validation.OtherPaymentReportValidator;
import drr.regulation.cftc.rewrite.validation.exists.OtherPaymentReportOnlyExistsValidator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;


/**
 * @version 5.50.0
 */
@RosettaMeta(model=OtherPaymentReport.class)
public class OtherPaymentReportMeta implements RosettaMetaData<OtherPaymentReport> {

	@Override
	public List<Validator<? super OtherPaymentReport>> dataRules(ValidatorFactory factory) {
		return Arrays.asList(
		);
	}
	
	@Override
	public List<Function<? super OtherPaymentReport, QualifyResult>> getQualifyFunctions(QualifyFunctionFactory factory) {
		return Collections.emptyList();
	}
	
	@Override
	public Validator<? super OtherPaymentReport> validator(ValidatorFactory factory) {
		return factory.<OtherPaymentReport>create(OtherPaymentReportValidator.class);
	}

	@Override
	public Validator<? super OtherPaymentReport> typeFormatValidator(ValidatorFactory factory) {
		return factory.<OtherPaymentReport>create(OtherPaymentReportTypeFormatValidator.class);
	}

	@Deprecated
	@Override
	public Validator<? super OtherPaymentReport> validator() {
		return new OtherPaymentReportValidator();
	}

	@Deprecated
	@Override
	public Validator<? super OtherPaymentReport> typeFormatValidator() {
		return new OtherPaymentReportTypeFormatValidator();
	}
	
	@Override
	public ValidatorWithArg<? super OtherPaymentReport, Set<String>> onlyExistsValidator() {
		return new OtherPaymentReportOnlyExistsValidator();
	}
}
