package drr.regulation.cftc.rewrite.reports;

import cdm.base.math.FinancialUnitEnum;
import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.UnitType;
import cdm.base.math.metafields.FieldWithMetaNonNegativeQuantitySchedule;
import cdm.base.math.metafields.ReferenceWithMetaNonNegativeQuantitySchedule;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.event.common.Trade;
import cdm.observable.asset.Price;
import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.metafields.ReferenceWithMetaPriceSchedule;
import cdm.product.asset.CreditDefaultPayout;
import cdm.product.common.settlement.FixedPrice;
import cdm.product.common.settlement.PriceQuantity;
import cdm.product.common.settlement.ResolvablePriceQuantity;
import cdm.product.qualification.functions.Qualify_AssetClass_InterestRate;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_Basis;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_FixedFloat;
import cdm.product.qualification.functions.Qualify_Commodity_Swaption;
import cdm.product.qualification.functions.Qualify_CreditDefaultSwaption;
import cdm.product.qualification.functions.Qualify_InterestRate_Option_Swaption;
import cdm.product.template.AveragingStrikeFeature;
import cdm.product.template.ContractualProduct;
import cdm.product.template.EconomicTerms;
import cdm.product.template.ForwardPayout;
import cdm.product.template.OptionExercise;
import cdm.product.template.OptionPayout;
import cdm.product.template.OptionStrike;
import cdm.product.template.Payout;
import cdm.product.template.PerformancePayout;
import cdm.product.template.Product;
import cdm.product.template.TradableProduct;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.BeforeTradeForEvent;
import drr.regulation.common.functions.CommodityLeg1;
import drr.regulation.common.functions.CommodityObservablePriceQuantity;
import drr.regulation.common.functions.ConvertNonISOToISOCurrency;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.FXLeg1;
import drr.regulation.common.functions.FXSwapLeg1;
import drr.regulation.common.functions.FixedPriceLeg1;
import drr.regulation.common.functions.InterestRateLeg1;
import drr.regulation.common.functions.InterestRateLeg2FixedFloatSingleCurrency;
import drr.regulation.common.functions.IsActionTypeTERM;
import drr.regulation.common.functions.IsCommodityOption;
import drr.regulation.common.functions.IsCreditDefaultSwap;
import drr.regulation.common.functions.IsEquity;
import drr.regulation.common.functions.IsEquityForward;
import drr.regulation.common.functions.IsEquityOption;
import drr.regulation.common.functions.IsFXForward;
import drr.regulation.common.functions.IsFXOption;
import drr.regulation.common.functions.IsFXSwap;
import drr.regulation.common.functions.IsFixedFloatZeroCouponSwapKnownAmount;
import drr.regulation.common.functions.IsInterestRateDebtOption;
import drr.regulation.common.functions.LastAvailableSpotPrice;
import drr.regulation.common.functions.ProductForTrade;
import drr.regulation.common.functions.TradeForEvent;
import drr.regulation.common.functions.UnderlierForProduct;
import drr.standards.iosco.cde.functions.CDEPerformanceNotionalCurrency;
import drr.standards.iosco.cde.reports.CDECommodityNotionalCurrencyRule;
import drr.standards.iosco.cde.reports.CDECreditNotionalCurrencyRule;
import drr.standards.iosco.cde.reports.CDEFXNotionalCurrencyRule;
import drr.standards.iosco.cde.reports.CDEInterestRateNotionalCurrencyRule;
import drr.standards.iosco.cde.reports.CDEOptionNotionalCurrencyRule;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(NotionalCurrencyLeg1Rule.NotionalCurrencyLeg1RuleDefault.class)
public abstract class NotionalCurrencyLeg1Rule implements ReportFunction<TransactionReportInstruction, ISOCurrencyCodeEnum> {
	
	// RosettaFunction dependencies
	//
	@Inject protected BeforeTradeForEvent beforeTradeForEvent;
	@Inject protected CDECommodityNotionalCurrencyRule cDECommodityNotionalCurrencyRule;
	@Inject protected CDECreditNotionalCurrencyRule cDECreditNotionalCurrencyRule;
	@Inject protected CDEFXNotionalCurrencyRule cDEFXNotionalCurrencyRule;
	@Inject protected CDEInterestRateNotionalCurrencyRule cDEInterestRateNotionalCurrencyRule;
	@Inject protected CDEOptionNotionalCurrencyRule cDEOptionNotionalCurrencyRule;
	@Inject protected CDEPerformanceNotionalCurrency cDEPerformanceNotionalCurrency;
	@Inject protected CommodityLeg1 commodityLeg1;
	@Inject protected CommodityObservablePriceQuantity commodityObservablePriceQuantity;
	@Inject protected ConvertNonISOToISOCurrency convertNonISOToISOCurrency;
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected FXLeg1 fXLeg1;
	@Inject protected FXSwapLeg1 fXSwapLeg1;
	@Inject protected FixedPriceLeg1 fixedPriceLeg1;
	@Inject protected InterestRateLeg1 interestRateLeg1;
	@Inject protected InterestRateLeg2FixedFloatSingleCurrency interestRateLeg2FixedFloatSingleCurrency;
	@Inject protected IsActionTypeTERM isActionTypeTERM;
	@Inject protected IsCommodityOption isCommodityOption;
	@Inject protected IsCreditDefaultSwap isCreditDefaultSwap;
	@Inject protected IsEquity isEquity;
	@Inject protected IsEquityForward isEquityForward;
	@Inject protected IsEquityOption isEquityOption;
	@Inject protected IsFXForward isFXForward;
	@Inject protected IsFXOption isFXOption;
	@Inject protected IsFXSwap isFXSwap;
	@Inject protected IsFixedFloatZeroCouponSwapKnownAmount isFixedFloatZeroCouponSwapKnownAmount;
	@Inject protected IsInterestRateDebtOption isInterestRateDebtOption;
	@Inject protected LastAvailableSpotPrice lastAvailableSpotPrice;
	@Inject protected ProductForTrade productForTrade;
	@Inject protected Qualify_AssetClass_InterestRate qualify_AssetClass_InterestRate;
	@Inject protected Qualify_Commodity_Swap_Basis qualify_Commodity_Swap_Basis;
	@Inject protected Qualify_Commodity_Swap_FixedFloat qualify_Commodity_Swap_FixedFloat;
	@Inject protected Qualify_Commodity_Swaption qualify_Commodity_Swaption;
	@Inject protected Qualify_CreditDefaultSwaption qualify_CreditDefaultSwaption;
	@Inject protected Qualify_InterestRate_Option_Swaption qualify_InterestRate_Option_Swaption;
	@Inject protected TradeForEvent tradeForEvent;
	@Inject protected UnderlierForProduct underlierForProduct;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public ISOCurrencyCodeEnum evaluate(TransactionReportInstruction input) {
		ISOCurrencyCodeEnum output = doEvaluate(input);
		
		return output;
	}

	protected abstract ISOCurrencyCodeEnum doEvaluate(TransactionReportInstruction input);

	public static class NotionalCurrencyLeg1RuleDefault extends NotionalCurrencyLeg1Rule {
		@Override
		protected ISOCurrencyCodeEnum doEvaluate(TransactionReportInstruction input) {
			ISOCurrencyCodeEnum output = null;
			return assignOutput(output, input);
		}
		
		protected ISOCurrencyCodeEnum assignOutput(ISOCurrencyCodeEnum output, TransactionReportInstruction input) {
			final MapperS<String> thenArg = MapperS.of(input)
				.mapSingleToItem(reportableEvent -> {
					final Boolean _boolean = isActionTypeTERM.evaluate(input);
					final MapperS<Trade> _thenArg;
					if ((_boolean == null ? false : _boolean)) {
						_thenArg = MapperS.of(beforeTradeForEvent.evaluate(input));
					} else {
						_thenArg = MapperS.of(tradeForEvent.evaluate(input));
					}
					return _thenArg
						.mapSingleToItem(item -> {
							final Boolean boolean0 = isCommodityOption.evaluate(productForTrade.evaluate(item.get()));
							if ((boolean0 == null ? false : boolean0)) {
								if (exists(MapperS.of(item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).get()).<OptionExercise>map("getExerciseTerms", optionPayout -> optionPayout.getExerciseTerms()).<OptionStrike>map("getStrike", optionExercise -> optionExercise.getStrike()).<Price>map("getStrikePrice", optionStrike -> optionStrike.getStrikePrice())).getOrDefault(false)) {
									return MapperS.of(cDEOptionNotionalCurrencyRule.evaluate(item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).get()));
								}
								if (exists(MapperS.of(item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).get()).<OptionExercise>map("getExerciseTerms", optionPayout -> optionPayout.getExerciseTerms()).<OptionStrike>map("getStrike", optionExercise -> optionExercise.getStrike()).<AveragingStrikeFeature>map("getAveragingStrikeFeature", optionStrike -> optionStrike.getAveragingStrikeFeature())).getOrDefault(false)) {
									if (exists(MapperS.of(lastAvailableSpotPrice.evaluate(reportableEvent.<ReportableInformation>map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).get()))).getOrDefault(false)) {
										return MapperS.of(lastAvailableSpotPrice.evaluate(reportableEvent.<ReportableInformation>map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).get())).<UnitType>map("getUnit", priceSchedule -> priceSchedule.getUnit()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency()).<String>map("Type coercion", fieldWithMetaString0 -> fieldWithMetaString0 == null ? null : fieldWithMetaString0.getValue());
									}
									final MapperC<FieldWithMetaNonNegativeQuantitySchedule> thenArg0 = MapperS.of(item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<TradeLot>mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).<PriceQuantity>mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).get()).<FieldWithMetaNonNegativeQuantitySchedule>mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity())
										.filterItemNullSafe(_item -> exists(_item.<NonNegativeQuantitySchedule>map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule == null ? null : fieldWithMetaNonNegativeQuantitySchedule.getValue()).<UnitType>map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency())).get());
									final MapperC<FieldWithMetaString> thenArg1 = thenArg0
										.mapItem(_item -> _item.<NonNegativeQuantitySchedule>map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule == null ? null : fieldWithMetaNonNegativeQuantitySchedule.getValue()).<UnitType>map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency()));
									return MapperS.of(thenArg1.get()).<String>map("Type coercion", fieldWithMetaString1 -> fieldWithMetaString1 == null ? null : fieldWithMetaString1.getValue());
								}
								return MapperS.<String>ofNull();
							}
							final Boolean boolean1 = qualify_CreditDefaultSwaption.evaluate(MapperS.of(productForTrade.evaluate(item.get())).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get());
							if ((boolean1 == null ? false : boolean1)) {
								return MapperS.of(cDECreditNotionalCurrencyRule.evaluate(MapperS.of(underlierForProduct.evaluate(productForTrade.evaluate(item.get()))).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).get()));
							}
							if (ComparisonResult.of(MapperS.of(isFXForward.evaluate(productForTrade.evaluate(item.get())))).or(ComparisonResult.of(MapperS.of(isFXOption.evaluate(productForTrade.evaluate(item.get()))))).getOrDefault(false)) {
								return MapperS.of(cDEFXNotionalCurrencyRule.evaluate(fXLeg1.evaluate(productForTrade.evaluate(item.get()))));
							}
							final Boolean boolean2 = isFXSwap.evaluate(productForTrade.evaluate(item.get()));
							if ((boolean2 == null ? false : boolean2)) {
								return MapperS.of(cDEFXNotionalCurrencyRule.evaluate(fXSwapLeg1.evaluate(productForTrade.evaluate(item.get()))));
							}
							if (areEqual(MapperS.of(qualify_InterestRate_Option_Swaption.evaluate(MapperS.of(productForTrade.evaluate(item.get())).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get())), MapperS.of(true), CardinalityOperator.All).getOrDefault(false)) {
								return MapperS.of(cDEInterestRateNotionalCurrencyRule.evaluate(interestRateLeg1.evaluate(underlierForProduct.evaluate(productForTrade.evaluate(item.get())))));
							}
							if (ComparisonResult.of(MapperS.of(isEquityOption.evaluate(productForTrade.evaluate(item.get())))).or(ComparisonResult.of(MapperS.of(isInterestRateDebtOption.evaluate(productForTrade.evaluate(item.get()))))).and(exists(MapperS.of(MapperS.of(economicTermsForProduct.evaluate(productForTrade.evaluate(item.get()))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).get()).<ResolvablePriceQuantity>map("getPriceQuantity", optionPayout -> optionPayout.getPriceQuantity()).<ReferenceWithMetaNonNegativeQuantitySchedule>map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).<NonNegativeQuantitySchedule>map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule0 -> referenceWithMetaNonNegativeQuantitySchedule0 == null ? null : referenceWithMetaNonNegativeQuantitySchedule0.getValue()).<UnitType>map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency()))).getOrDefault(false)) {
								return MapperS.of(MapperS.of(economicTermsForProduct.evaluate(productForTrade.evaluate(item.get()))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).get()).<ResolvablePriceQuantity>map("getPriceQuantity", optionPayout -> optionPayout.getPriceQuantity()).<ReferenceWithMetaNonNegativeQuantitySchedule>map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).<NonNegativeQuantitySchedule>map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule1 -> referenceWithMetaNonNegativeQuantitySchedule1 == null ? null : referenceWithMetaNonNegativeQuantitySchedule1.getValue()).<UnitType>map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency()).<String>map("Type coercion", fieldWithMetaString2 -> fieldWithMetaString2 == null ? null : fieldWithMetaString2.getValue());
							}
							if (ComparisonResult.of(MapperS.of(isEquityOption.evaluate(productForTrade.evaluate(item.get())))).or(ComparisonResult.of(MapperS.of(isInterestRateDebtOption.evaluate(productForTrade.evaluate(item.get()))))).and(exists(MapperS.of(MapperS.of(economicTermsForProduct.evaluate(productForTrade.evaluate(item.get()))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).get()).<ResolvablePriceQuantity>map("getPriceQuantity", optionPayout -> optionPayout.getPriceQuantity()).<ReferenceWithMetaNonNegativeQuantitySchedule>map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).<NonNegativeQuantitySchedule>map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule2 -> referenceWithMetaNonNegativeQuantitySchedule2 == null ? null : referenceWithMetaNonNegativeQuantitySchedule2.getValue()).<UnitType>map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).<FinancialUnitEnum>map("getFinancialUnit", unitType -> unitType.getFinancialUnit()))).getOrDefault(false)) {
								return MapperS.of(MapperS.of(economicTermsForProduct.evaluate(productForTrade.evaluate(item.get()))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).get()).<OptionExercise>map("getExerciseTerms", optionPayout -> optionPayout.getExerciseTerms()).<OptionStrike>map("getStrike", optionExercise -> optionExercise.getStrike()).<Price>map("getStrikePrice", optionStrike -> optionStrike.getStrikePrice()).<UnitType>map("getUnit", price -> price.getUnit()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency()).<String>map("Type coercion", fieldWithMetaString3 -> fieldWithMetaString3 == null ? null : fieldWithMetaString3.getValue());
							}
							final Boolean boolean3 = isEquityForward.evaluate(productForTrade.evaluate(item.get()));
							if ((boolean3 == null ? false : boolean3)) {
								if (exists(MapperS.of(MapperS.of(economicTermsForProduct.evaluate(productForTrade.evaluate(item.get()))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<ForwardPayout>mapC("getForwardPayout", payout -> payout.getForwardPayout()).get()).<ResolvablePriceQuantity>map("getPriceQuantity", forwardPayout -> forwardPayout.getPriceQuantity()).<ReferenceWithMetaNonNegativeQuantitySchedule>map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).<NonNegativeQuantitySchedule>map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule3 -> referenceWithMetaNonNegativeQuantitySchedule3 == null ? null : referenceWithMetaNonNegativeQuantitySchedule3.getValue()).<UnitType>map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency())).getOrDefault(false)) {
									return MapperS.of(MapperS.of(economicTermsForProduct.evaluate(productForTrade.evaluate(item.get()))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<ForwardPayout>mapC("getForwardPayout", payout -> payout.getForwardPayout()).get()).<ResolvablePriceQuantity>map("getPriceQuantity", forwardPayout -> forwardPayout.getPriceQuantity()).<ReferenceWithMetaNonNegativeQuantitySchedule>map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).<NonNegativeQuantitySchedule>map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule4 -> referenceWithMetaNonNegativeQuantitySchedule4 == null ? null : referenceWithMetaNonNegativeQuantitySchedule4.getValue()).<UnitType>map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency()).<String>map("Type coercion", fieldWithMetaString4 -> fieldWithMetaString4 == null ? null : fieldWithMetaString4.getValue());
								}
								final ReferenceWithMetaPriceSchedule referenceWithMetaPriceSchedule0 = MapperS.of(MapperS.of(economicTermsForProduct.evaluate(productForTrade.evaluate(item.get()))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<ForwardPayout>mapC("getForwardPayout", payout -> payout.getForwardPayout()).get()).<ResolvablePriceQuantity>map("getPriceQuantity", forwardPayout -> forwardPayout.getPriceQuantity()).<ReferenceWithMetaPriceSchedule>mapC("getPriceSchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getPriceSchedule()).get();
								return (referenceWithMetaPriceSchedule0 == null ? MapperS.<PriceSchedule>ofNull() : MapperS.of(referenceWithMetaPriceSchedule0.getValue())).<UnitType>map("getUnit", priceSchedule -> priceSchedule.getUnit()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency()).<String>map("Type coercion", fieldWithMetaString5 -> fieldWithMetaString5 == null ? null : fieldWithMetaString5.getValue());
							}
							final Boolean boolean4 = isEquity.evaluate(productForTrade.evaluate(item.get()));
							if ((boolean4 == null ? false : boolean4)) {
								return MapperS.of(cDEPerformanceNotionalCurrency.evaluate(MapperS.of(economicTermsForProduct.evaluate(productForTrade.evaluate(item.get()))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).getMulti()));
							}
							final Boolean boolean5 = isCreditDefaultSwap.evaluate(productForTrade.evaluate(item.get()));
							if ((boolean5 == null ? false : boolean5)) {
								return MapperS.of(cDECreditNotionalCurrencyRule.evaluate(item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).get()));
							}
							final Boolean boolean6 = qualify_Commodity_Swap_FixedFloat.evaluate(item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get());
							if ((boolean6 == null ? false : boolean6)) {
								final ReferenceWithMetaPriceSchedule referenceWithMetaPriceSchedule1 = MapperS.of(fixedPriceLeg1.evaluate(item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).get())).<FixedPrice>map("getFixedPrice", fixedPricePayout -> fixedPricePayout.getFixedPrice()).<ReferenceWithMetaPriceSchedule>map("getPrice", fixedPrice -> fixedPrice.getPrice()).get();
								return MapperS.of(cDECommodityNotionalCurrencyRule.evaluate((referenceWithMetaPriceSchedule1 == null ? null : referenceWithMetaPriceSchedule1.getValue())));
							}
							if (ComparisonResult.of(MapperS.of(qualify_Commodity_Swaption.evaluate(item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get()))).and(ComparisonResult.of(MapperS.of(qualify_Commodity_Swap_FixedFloat.evaluate(MapperS.of(underlierForProduct.evaluate(productForTrade.evaluate(item.get()))).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get())))).getOrDefault(false)) {
								final ReferenceWithMetaPriceSchedule referenceWithMetaPriceSchedule2 = MapperS.of(fixedPriceLeg1.evaluate(underlierForProduct.evaluate(item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).get()))).<FixedPrice>map("getFixedPrice", fixedPricePayout -> fixedPricePayout.getFixedPrice()).<ReferenceWithMetaPriceSchedule>map("getPrice", fixedPrice -> fixedPrice.getPrice()).get();
								return MapperS.of(cDECommodityNotionalCurrencyRule.evaluate((referenceWithMetaPriceSchedule2 == null ? null : referenceWithMetaPriceSchedule2.getValue())));
							}
							if (ComparisonResult.of(MapperS.of(qualify_Commodity_Swaption.evaluate(item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get()))).and(ComparisonResult.of(MapperS.of(qualify_Commodity_Swap_Basis.evaluate(MapperS.of(underlierForProduct.evaluate(productForTrade.evaluate(item.get()))).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get())))).getOrDefault(false)) {
								if (exists(MapperS.of(lastAvailableSpotPrice.evaluate(reportableEvent.<ReportableInformation>map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).get()))).getOrDefault(false)) {
									return MapperS.of(lastAvailableSpotPrice.evaluate(reportableEvent.<ReportableInformation>map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).get())).<UnitType>map("getUnit", priceSchedule -> priceSchedule.getUnit()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency()).<String>map("Type coercion", fieldWithMetaString6 -> fieldWithMetaString6 == null ? null : fieldWithMetaString6.getValue());
								}
								final MapperC<FieldWithMetaNonNegativeQuantitySchedule> thenArg2 = MapperS.of(commodityObservablePriceQuantity.evaluate(item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<TradeLot>mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get(), commodityLeg1.evaluate(productForTrade.evaluate(item.get())))).<FieldWithMetaNonNegativeQuantitySchedule>mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity())
									.filterItemNullSafe(_item -> exists(_item.<NonNegativeQuantitySchedule>map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule == null ? null : fieldWithMetaNonNegativeQuantitySchedule.getValue()).<UnitType>map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency())).get());
								final MapperC<FieldWithMetaString> thenArg3 = thenArg2
									.mapItem(_item -> _item.<NonNegativeQuantitySchedule>map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule == null ? null : fieldWithMetaNonNegativeQuantitySchedule.getValue()).<UnitType>map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency()));
								return MapperS.of(thenArg3.get()).<String>map("Type coercion", fieldWithMetaString7 -> fieldWithMetaString7 == null ? null : fieldWithMetaString7.getValue());
							}
							final Boolean boolean7 = qualify_Commodity_Swap_Basis.evaluate(item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get());
							if ((boolean7 == null ? false : boolean7)) {
								if (exists(MapperS.of(lastAvailableSpotPrice.evaluate(reportableEvent.<ReportableInformation>map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).get()))).getOrDefault(false)) {
									return MapperS.of(lastAvailableSpotPrice.evaluate(reportableEvent.<ReportableInformation>map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).get())).<UnitType>map("getUnit", priceSchedule -> priceSchedule.getUnit()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency()).<String>map("Type coercion", fieldWithMetaString8 -> fieldWithMetaString8 == null ? null : fieldWithMetaString8.getValue());
								}
								final MapperC<FieldWithMetaNonNegativeQuantitySchedule> thenArg4 = MapperS.of(commodityObservablePriceQuantity.evaluate(item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<TradeLot>mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get(), commodityLeg1.evaluate(productForTrade.evaluate(item.get())))).<FieldWithMetaNonNegativeQuantitySchedule>mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity())
									.filterItemNullSafe(_item -> exists(_item.<NonNegativeQuantitySchedule>map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule == null ? null : fieldWithMetaNonNegativeQuantitySchedule.getValue()).<UnitType>map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency())).get());
								final MapperC<FieldWithMetaString> thenArg5 = thenArg4
									.mapItem(_item -> _item.<NonNegativeQuantitySchedule>map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule == null ? null : fieldWithMetaNonNegativeQuantitySchedule.getValue()).<UnitType>map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency()));
								return MapperS.of(thenArg5.get()).<String>map("Type coercion", fieldWithMetaString9 -> fieldWithMetaString9 == null ? null : fieldWithMetaString9.getValue());
							}
							final Boolean boolean8 = isFixedFloatZeroCouponSwapKnownAmount.evaluate(productForTrade.evaluate(item.get()));
							if ((boolean8 == null ? false : boolean8)) {
								return MapperS.of(cDEInterestRateNotionalCurrencyRule.evaluate(interestRateLeg2FixedFloatSingleCurrency.evaluate(productForTrade.evaluate(item.get()))));
							}
							if (areEqual(MapperS.of(qualify_AssetClass_InterestRate.evaluate(MapperS.of(productForTrade.evaluate(item.get())).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get())), MapperS.of(true), CardinalityOperator.All).getOrDefault(false)) {
								return MapperS.of(cDEInterestRateNotionalCurrencyRule.evaluate(interestRateLeg1.evaluate(productForTrade.evaluate(item.get()))));
							}
							return MapperS.<String>ofNull();
						});
				});
			output = thenArg
				.mapSingleToItem(item -> MapperS.of(convertNonISOToISOCurrency.evaluate(item.get()))).get();
			
			return output;
		}
	}
}
