package drr.regulation.cftc.rewrite.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.GetNotationString;
import drr.regulation.common.functions.GetPackageInformation;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(PackageTransactionSpreadNotationRule.PackageTransactionSpreadNotationRuleDefault.class)
public abstract class PackageTransactionSpreadNotationRule implements ReportFunction<TransactionReportInstruction, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected GetNotationString getNotationString;
	@Inject protected GetPackageInformation getPackageInformation;
	@Inject protected GetPackageTransactionSpreadNotationEnumRule getPackageTransactionSpreadNotationEnumRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(TransactionReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(TransactionReportInstruction input);

	public static class PackageTransactionSpreadNotationRuleDefault extends PackageTransactionSpreadNotationRule {
		@Override
		protected String doEvaluate(TransactionReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, TransactionReportInstruction input) {
			output = MapperS.of(input)
				.mapSingleToItem(item -> {
					if (exists(MapperS.of(getPackageInformation.evaluate(item.get()))).getOrDefault(false)) {
						return MapperS.of(getNotationString.evaluate(getPackageTransactionSpreadNotationEnumRule.evaluate(item.get())));
					}
					return MapperS.<String>ofNull();
				}).get();
			
			return output;
		}
	}
}
