package drr.regulation.cftc.rewrite.reports;

import cdm.event.common.Trade;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.BeforeTradeForEvent;
import drr.regulation.common.functions.IsActionTypeTERM;
import drr.regulation.common.functions.TradeForEvent;
import drr.standards.iosco.cde.functions.ExtractCDEPutAmount;
import java.math.BigDecimal;
import javax.inject.Inject;


@ImplementedBy(PutAmountRule.PutAmountRuleDefault.class)
public abstract class PutAmountRule implements ReportFunction<TransactionReportInstruction, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected BeforeTradeForEvent beforeTradeForEvent;
	@Inject protected ExtractCDEPutAmount extractCDEPutAmount;
	@Inject protected IsActionTypeTERM isActionTypeTERM;
	@Inject protected TradeForEvent tradeForEvent;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(TransactionReportInstruction input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(TransactionReportInstruction input);

	public static class PutAmountRuleDefault extends PutAmountRule {
		@Override
		protected BigDecimal doEvaluate(TransactionReportInstruction input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
			final MapperS<Trade> thenArg = MapperS.of(input)
				.mapSingleToItem(item -> {
					final Boolean _boolean = isActionTypeTERM.evaluate(item.get());
					if ((_boolean == null ? false : _boolean)) {
						return MapperS.of(beforeTradeForEvent.evaluate(item.get()));
					}
					return MapperS.of(tradeForEvent.evaluate(item.get()));
				});
			output = MapperS.of(extractCDEPutAmount.evaluate(thenArg.get(), new BigDecimal("99999999999999999999.99999"))).get();
			
			return output;
		}
	}
}
