package drr.regulation.cftc.rewrite.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.cftc.rewrite.CFTCGuidebookPart45;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class CFTCGuidebookPart45TypeFormatValidator implements Validator<CFTCGuidebookPart45> {

	private List<ComparisonResult> getComparisonResults(CFTCGuidebookPart45 o) {
		return Lists.<ComparisonResult>newArrayList(
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCGuidebookPart45 o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("CFTCGuidebookPart45", ValidationResult.ValidationType.TYPE_FORMAT, "CFTCGuidebookPart45", path, "", res.getError());
				}
				return success("CFTCGuidebookPart45", ValidationResult.ValidationType.TYPE_FORMAT, "CFTCGuidebookPart45", path, "");
			})
			.collect(toList());
	}

}
