package drr.regulation.cftc.rewrite.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.cftc.rewrite.CFTCGuidebookPart43;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.50.0
 */
@RosettaDataRule("CFTCGuidebookPart43LargeNotionalOffFacilitySwapElectionIndicator")
@ImplementedBy(CFTCGuidebookPart43LargeNotionalOffFacilitySwapElectionIndicator.Default.class)
public interface CFTCGuidebookPart43LargeNotionalOffFacilitySwapElectionIndicator extends Validator<CFTCGuidebookPart43> {
	
	String NAME = "CFTCGuidebookPart43LargeNotionalOffFacilitySwapElectionIndicator";
	String DEFINITION = "if sefOrDcmIndicator = True then largeNotionalOffFacilitySwapElectionIndicator is absent";
	
	class Default implements CFTCGuidebookPart43LargeNotionalOffFacilitySwapElectionIndicator {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCGuidebookPart43 cFTCGuidebookPart43) {
			ComparisonResult result = executeDataRule(cFTCGuidebookPart43);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCGuidebookPart43", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCGuidebookPart43", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(CFTCGuidebookPart43 cFTCGuidebookPart43) {
			try {
				if (areEqual(MapperS.of(cFTCGuidebookPart43).<Boolean>map("getSefOrDcmIndicator", _cFTCGuidebookPart43 -> _cFTCGuidebookPart43.getSefOrDcmIndicator()), MapperS.of(true), CardinalityOperator.All).getOrDefault(false)) {
					return notExists(MapperS.of(cFTCGuidebookPart43).<Boolean>map("getLargeNotionalOffFacilitySwapElectionIndicator", _cFTCGuidebookPart43 -> _cFTCGuidebookPart43.getLargeNotionalOffFacilitySwapElectionIndicator()));
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements CFTCGuidebookPart43LargeNotionalOffFacilitySwapElectionIndicator {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCGuidebookPart43 cFTCGuidebookPart43) {
			return Collections.emptyList();
		}
	}
}
