package drr.regulation.cftc.rewrite.validation.datarule;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.cftc.rewrite.CFTCGuidebookPart43;
import drr.regulation.cftc.rewrite.CFTCPart43TransactionReport;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.50.0
 */
@RosettaDataRule("CFTCPart43TransactionReportNotionalCurrencyCondition")
@ImplementedBy(CFTCPart43TransactionReportNotionalCurrencyCondition.Default.class)
public interface CFTCPart43TransactionReportNotionalCurrencyCondition extends Validator<CFTCPart43TransactionReport> {
	
	String NAME = "CFTCPart43TransactionReportNotionalCurrencyCondition";
	String DEFINITION = "if cftcGuidebook -> optionStyle exists then ((if notionalCurrencyLeg1 exists then notionalCurrencyLeg1 any = [callCurrency, putCurrency]) and (if notionalCurrencyLeg2 exists then notionalCurrencyLeg2 any = [callCurrency, putCurrency]))";
	
	class Default implements CFTCPart43TransactionReportNotionalCurrencyCondition {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart43TransactionReport cFTCPart43TransactionReport) {
			ComparisonResult result = executeDataRule(cFTCPart43TransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCPart43TransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCPart43TransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(CFTCPart43TransactionReport cFTCPart43TransactionReport) {
			try {
				if (exists(MapperS.of(cFTCPart43TransactionReport).<CFTCGuidebookPart43>map("getCftcGuidebook", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getCftcGuidebook()).<String>map("getOptionStyle", cFTCGuidebookPart43 -> cFTCGuidebookPart43.getOptionStyle())).getOrDefault(false)) {
					final ComparisonResult ifThenElseResult0;
					if (exists(MapperS.of(cFTCPart43TransactionReport).<ISOCurrencyCodeEnum>map("getNotionalCurrencyLeg1", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getNotionalCurrencyLeg1())).getOrDefault(false)) {
						ifThenElseResult0 = areEqual(MapperS.of(cFTCPart43TransactionReport).<ISOCurrencyCodeEnum>map("getNotionalCurrencyLeg1", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getNotionalCurrencyLeg1()), MapperC.<ISOCurrencyCodeEnum>of(MapperS.of(cFTCPart43TransactionReport).<ISOCurrencyCodeEnum>map("getCallCurrency", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getCallCurrency()), MapperS.of(cFTCPart43TransactionReport).<ISOCurrencyCodeEnum>map("getPutCurrency", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getPutCurrency())), CardinalityOperator.Any);
					} else {
						ifThenElseResult0 = ComparisonResult.successEmptyOperand("");
					}
					final ComparisonResult ifThenElseResult1;
					if (exists(MapperS.of(cFTCPart43TransactionReport).<ISOCurrencyCodeEnum>map("getNotionalCurrencyLeg2", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getNotionalCurrencyLeg2())).getOrDefault(false)) {
						ifThenElseResult1 = areEqual(MapperS.of(cFTCPart43TransactionReport).<ISOCurrencyCodeEnum>map("getNotionalCurrencyLeg2", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getNotionalCurrencyLeg2()), MapperC.<ISOCurrencyCodeEnum>of(MapperS.of(cFTCPart43TransactionReport).<ISOCurrencyCodeEnum>map("getCallCurrency", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getCallCurrency()), MapperS.of(cFTCPart43TransactionReport).<ISOCurrencyCodeEnum>map("getPutCurrency", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getPutCurrency())), CardinalityOperator.Any);
					} else {
						ifThenElseResult1 = ComparisonResult.successEmptyOperand("");
					}
					return ifThenElseResult0.and(ifThenElseResult1);
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements CFTCPart43TransactionReportNotionalCurrencyCondition {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart43TransactionReport cFTCPart43TransactionReport) {
			return Collections.emptyList();
		}
	}
}
