package drr.regulation.cftc.rewrite.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.cftc.rewrite.CFTCPart45TransactionReport;
import drr.regulation.common.ActionTypeEnum;
import drr.regulation.common.EventTypeEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.50.0
 */
@RosettaDataRule("CFTCPart45TransactionReportEventTypeCondition")
@ImplementedBy(CFTCPart45TransactionReportEventTypeCondition.Default.class)
public interface CFTCPart45TransactionReportEventTypeCondition extends Validator<CFTCPart45TransactionReport> {
	
	String NAME = "CFTCPart45TransactionReportEventTypeCondition";
	String DEFINITION = "if actionType = ActionTypeEnum -> NEWT to-string then [ EventTypeEnum -> TRAD to-string, EventTypeEnum -> NOVA to-string, EventTypeEnum -> COMP to-string, EventTypeEnum -> CLRG to-string, EventTypeEnum -> EXER to-string, EventTypeEnum -> ALOC to-string, EventTypeEnum -> CLAL to-string, EventTypeEnum -> PTNG to-string, EventTypeEnum -> CORP to-string ] any = eventType else if actionType = ActionTypeEnum -> MODI to-string then [ EventTypeEnum -> TRAD to-string, EventTypeEnum -> NOVA to-string, EventTypeEnum -> COMP to-string, EventTypeEnum -> EXER to-string, EventTypeEnum -> ALOC to-string, EventTypeEnum -> CREV to-string, EventTypeEnum -> CORP to-string, EventTypeEnum -> UPDT to-string ] any = eventType else if actionType = ActionTypeEnum -> TERM to-string then [ EventTypeEnum -> NOVA to-string, EventTypeEnum -> COMP to-string, EventTypeEnum -> ETRM to-string, EventTypeEnum -> CLRG to-string, EventTypeEnum -> EXER to-string, EventTypeEnum -> ALOC to-string, EventTypeEnum -> CLAL to-string, EventTypeEnum -> CREV to-string, EventTypeEnum -> CORP to-string ] any = eventType else if actionType = ActionTypeEnum -> PRTO to-string then eventType = EventTypeEnum -> PTNG to-string else [ ActionTypeEnum -> CORR to-string, ActionTypeEnum -> EROR to-string, ActionTypeEnum -> REVI to-string, ActionTypeEnum -> VALU to-string, ActionTypeEnum -> MARU to-string ] any = actionType and eventType is absent";
	
	class Default implements CFTCPart45TransactionReportEventTypeCondition {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart45TransactionReport cFTCPart45TransactionReport) {
			ComparisonResult result = executeDataRule(cFTCPart45TransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCPart45TransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCPart45TransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(CFTCPart45TransactionReport cFTCPart45TransactionReport) {
			try {
				if (areEqual(MapperS.of(cFTCPart45TransactionReport).<String>map("getActionType", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getActionType()), MapperS.of(ActionTypeEnum.NEWT).map("to-string", ActionTypeEnum::toDisplayString), CardinalityOperator.All).getOrDefault(false)) {
					return areEqual(MapperC.<String>of(MapperS.of(EventTypeEnum.TRAD).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.NOVA).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.COMP).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.CLRG).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.EXER).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.ALOC).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.CLAL).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.PTNG).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.CORP).map("to-string", EventTypeEnum::toDisplayString)), MapperS.of(cFTCPart45TransactionReport).<String>map("getEventType", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getEventType()), CardinalityOperator.Any);
				}
				if (areEqual(MapperS.of(cFTCPart45TransactionReport).<String>map("getActionType", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getActionType()), MapperS.of(ActionTypeEnum.MODI).map("to-string", ActionTypeEnum::toDisplayString), CardinalityOperator.All).getOrDefault(false)) {
					return areEqual(MapperC.<String>of(MapperS.of(EventTypeEnum.TRAD).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.NOVA).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.COMP).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.EXER).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.ALOC).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.CREV).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.CORP).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.UPDT).map("to-string", EventTypeEnum::toDisplayString)), MapperS.of(cFTCPart45TransactionReport).<String>map("getEventType", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getEventType()), CardinalityOperator.Any);
				}
				if (areEqual(MapperS.of(cFTCPart45TransactionReport).<String>map("getActionType", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getActionType()), MapperS.of(ActionTypeEnum.TERM).map("to-string", ActionTypeEnum::toDisplayString), CardinalityOperator.All).getOrDefault(false)) {
					return areEqual(MapperC.<String>of(MapperS.of(EventTypeEnum.NOVA).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.COMP).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.ETRM).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.CLRG).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.EXER).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.ALOC).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.CLAL).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.CREV).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.CORP).map("to-string", EventTypeEnum::toDisplayString)), MapperS.of(cFTCPart45TransactionReport).<String>map("getEventType", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getEventType()), CardinalityOperator.Any);
				}
				if (areEqual(MapperS.of(cFTCPart45TransactionReport).<String>map("getActionType", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getActionType()), MapperS.of(ActionTypeEnum.PRTO).map("to-string", ActionTypeEnum::toDisplayString), CardinalityOperator.All).getOrDefault(false)) {
					return areEqual(MapperS.of(cFTCPart45TransactionReport).<String>map("getEventType", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getEventType()), MapperS.of(EventTypeEnum.PTNG).map("to-string", EventTypeEnum::toDisplayString), CardinalityOperator.All);
				}
				return areEqual(MapperC.<String>of(MapperS.of(ActionTypeEnum.CORR).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.EROR).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.REVI).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.VALU).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.MARU).map("to-string", ActionTypeEnum::toDisplayString)), MapperS.of(cFTCPart45TransactionReport).<String>map("getActionType", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getActionType()), CardinalityOperator.Any).and(notExists(MapperS.of(cFTCPart45TransactionReport).<String>map("getEventType", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getEventType())));
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements CFTCPart45TransactionReportEventTypeCondition {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart45TransactionReport cFTCPart45TransactionReport) {
			return Collections.emptyList();
		}
	}
}
