package drr.regulation.cftc.rewrite.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.cftc.rewrite.CFTCGuidebookPart45;
import drr.regulation.cftc.rewrite.CFTCPart45TransactionReport;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.50.0
 */
@RosettaDataRule("CFTCPart45TransactionReportPriceNotationCondition")
@ImplementedBy(CFTCPart45TransactionReportPriceNotationCondition.Default.class)
public interface CFTCPart45TransactionReportPriceNotationCondition extends Validator<CFTCPart45TransactionReport> {
	
	String NAME = "CFTCPart45TransactionReportPriceNotationCondition";
	String DEFINITION = "if [\"Equity\", \"Commodity\"] any = cftcGuidebook -> assetClass and price exists then priceNotation exists else priceNotation is absent";
	
	class Default implements CFTCPart45TransactionReportPriceNotationCondition {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart45TransactionReport cFTCPart45TransactionReport) {
			ComparisonResult result = executeDataRule(cFTCPart45TransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCPart45TransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCPart45TransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(CFTCPart45TransactionReport cFTCPart45TransactionReport) {
			try {
				if (areEqual(MapperC.<String>of(MapperS.of("Equity"), MapperS.of("Commodity")), MapperS.of(cFTCPart45TransactionReport).<CFTCGuidebookPart45>map("getCftcGuidebook", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getCftcGuidebook()).<String>map("getAssetClass", cFTCGuidebookPart45 -> cFTCGuidebookPart45.getAssetClass()), CardinalityOperator.Any).and(exists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getPrice", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getPrice()))).getOrDefault(false)) {
					return exists(MapperS.of(cFTCPart45TransactionReport).<String>map("getPriceNotation", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getPriceNotation()));
				}
				return notExists(MapperS.of(cFTCPart45TransactionReport).<String>map("getPriceNotation", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getPriceNotation()));
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements CFTCPart45TransactionReportPriceNotationCondition {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart45TransactionReport cFTCPart45TransactionReport) {
			return Collections.emptyList();
		}
	}
}
