package drr.regulation.cftc.rewrite.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.cftc.rewrite.CFTCGuidebookPart45;
import drr.regulation.cftc.rewrite.CFTCPart45TransactionReport;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.50.0
 */
@RosettaDataRule("CFTCPart45TransactionReportQuantityFrequencyMultiplierCondition")
@ImplementedBy(CFTCPart45TransactionReportQuantityFrequencyMultiplierCondition.Default.class)
public interface CFTCPart45TransactionReportQuantityFrequencyMultiplierCondition extends Validator<CFTCPart45TransactionReport> {
	
	String NAME = "CFTCPart45TransactionReportQuantityFrequencyMultiplierCondition";
	String DEFINITION = "if cftcGuidebook -> assetClass = \"Commodity\" then ((if quantityFrequencyLeg1 exists and [\"ONDE\", \"ADHO\"] any <> quantityFrequencyLeg1 then quantityFrequencyMultiplierLeg1 exists else quantityFrequencyMultiplierLeg1 is absent) and (if quantityFrequencyLeg2 exists and [\"ONDE\", \"ADHO\"] any <> quantityFrequencyLeg2 then quantityFrequencyMultiplierLeg2 exists else quantityFrequencyMultiplierLeg2 is absent)) else quantityFrequencyMultiplierLeg1 is absent and quantityFrequencyMultiplierLeg2 is absent";
	
	class Default implements CFTCPart45TransactionReportQuantityFrequencyMultiplierCondition {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart45TransactionReport cFTCPart45TransactionReport) {
			ComparisonResult result = executeDataRule(cFTCPart45TransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCPart45TransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCPart45TransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(CFTCPart45TransactionReport cFTCPart45TransactionReport) {
			try {
				if (areEqual(MapperS.of(cFTCPart45TransactionReport).<CFTCGuidebookPart45>map("getCftcGuidebook", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getCftcGuidebook()).<String>map("getAssetClass", cFTCGuidebookPart45 -> cFTCGuidebookPart45.getAssetClass()), MapperS.of("Commodity"), CardinalityOperator.All).getOrDefault(false)) {
					final ComparisonResult ifThenElseResult0;
					if (exists(MapperS.of(cFTCPart45TransactionReport).<String>map("getQuantityFrequencyLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getQuantityFrequencyLeg1())).and(notEqual(MapperC.<String>of(MapperS.of("ONDE"), MapperS.of("ADHO")), MapperS.of(cFTCPart45TransactionReport).<String>map("getQuantityFrequencyLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getQuantityFrequencyLeg1()), CardinalityOperator.Any)).getOrDefault(false)) {
						ifThenElseResult0 = exists(MapperS.of(cFTCPart45TransactionReport).<Integer>map("getQuantityFrequencyMultiplierLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getQuantityFrequencyMultiplierLeg1()));
					} else {
						ifThenElseResult0 = notExists(MapperS.of(cFTCPart45TransactionReport).<Integer>map("getQuantityFrequencyMultiplierLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getQuantityFrequencyMultiplierLeg1()));
					}
					final ComparisonResult ifThenElseResult1;
					if (exists(MapperS.of(cFTCPart45TransactionReport).<String>map("getQuantityFrequencyLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getQuantityFrequencyLeg2())).and(notEqual(MapperC.<String>of(MapperS.of("ONDE"), MapperS.of("ADHO")), MapperS.of(cFTCPart45TransactionReport).<String>map("getQuantityFrequencyLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getQuantityFrequencyLeg2()), CardinalityOperator.Any)).getOrDefault(false)) {
						ifThenElseResult1 = exists(MapperS.of(cFTCPart45TransactionReport).<Integer>map("getQuantityFrequencyMultiplierLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getQuantityFrequencyMultiplierLeg2()));
					} else {
						ifThenElseResult1 = notExists(MapperS.of(cFTCPart45TransactionReport).<Integer>map("getQuantityFrequencyMultiplierLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getQuantityFrequencyMultiplierLeg2()));
					}
					return ifThenElseResult0.and(ifThenElseResult1);
				}
				return notExists(MapperS.of(cFTCPart45TransactionReport).<Integer>map("getQuantityFrequencyMultiplierLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getQuantityFrequencyMultiplierLeg1())).and(notExists(MapperS.of(cFTCPart45TransactionReport).<Integer>map("getQuantityFrequencyMultiplierLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getQuantityFrequencyMultiplierLeg2())));
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements CFTCPart45TransactionReportQuantityFrequencyMultiplierCondition {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart45TransactionReport cFTCPart45TransactionReport) {
			return Collections.emptyList();
		}
	}
}
