package drr.regulation.cftc.rewrite.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.cftc.rewrite.CFTCGuidebookPart45;
import drr.regulation.cftc.rewrite.CFTCPart45TransactionReport;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.50.0
 */
@RosettaDataRule("CFTCPart45TransactionReportQuantityUnitOfMeasureCondition")
@ImplementedBy(CFTCPart45TransactionReportQuantityUnitOfMeasureCondition.Default.class)
public interface CFTCPart45TransactionReportQuantityUnitOfMeasureCondition extends Validator<CFTCPart45TransactionReport> {
	
	String NAME = "CFTCPart45TransactionReportQuantityUnitOfMeasureCondition";
	String DEFINITION = "if [\"Commodity\", \"Equity\"] any = cftcGuidebook -> assetClass then quantityUnitOfMeasureLeg1 exists or quantityUnitOfMeasureLeg2 exists else quantityUnitOfMeasureLeg1 is absent and quantityUnitOfMeasureLeg2 is absent";
	
	class Default implements CFTCPart45TransactionReportQuantityUnitOfMeasureCondition {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart45TransactionReport cFTCPart45TransactionReport) {
			ComparisonResult result = executeDataRule(cFTCPart45TransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCPart45TransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCPart45TransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(CFTCPart45TransactionReport cFTCPart45TransactionReport) {
			try {
				if (areEqual(MapperC.<String>of(MapperS.of("Commodity"), MapperS.of("Equity")), MapperS.of(cFTCPart45TransactionReport).<CFTCGuidebookPart45>map("getCftcGuidebook", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getCftcGuidebook()).<String>map("getAssetClass", cFTCGuidebookPart45 -> cFTCGuidebookPart45.getAssetClass()), CardinalityOperator.Any).getOrDefault(false)) {
					return exists(MapperS.of(cFTCPart45TransactionReport).<String>map("getQuantityUnitOfMeasureLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getQuantityUnitOfMeasureLeg1())).or(exists(MapperS.of(cFTCPart45TransactionReport).<String>map("getQuantityUnitOfMeasureLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getQuantityUnitOfMeasureLeg2())));
				}
				return notExists(MapperS.of(cFTCPart45TransactionReport).<String>map("getQuantityUnitOfMeasureLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getQuantityUnitOfMeasureLeg1())).and(notExists(MapperS.of(cFTCPart45TransactionReport).<String>map("getQuantityUnitOfMeasureLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getQuantityUnitOfMeasureLeg2())));
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements CFTCPart45TransactionReportQuantityUnitOfMeasureCondition {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart45TransactionReport cFTCPart45TransactionReport) {
			return Collections.emptyList();
		}
	}
}
