package drr.regulation.cftc.rewrite.validation.datarule;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.cftc.rewrite.CFTCGuidebookPart45;
import drr.regulation.cftc.rewrite.CFTCPart45TransactionReport;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.50.0
 */
@RosettaDataRule("CFTCPart45TransactionReportSpreadCurrencyCondition")
@ImplementedBy(CFTCPart45TransactionReportSpreadCurrencyCondition.Default.class)
public interface CFTCPart45TransactionReportSpreadCurrencyCondition extends Validator<CFTCPart45TransactionReport> {
	
	String NAME = "CFTCPart45TransactionReportSpreadCurrencyCondition";
	String DEFINITION = "(if [\"Credit\", \"InterestRate\", \"Equity\", \"Commodity\"] any = cftcGuidebook -> assetClass and spreadNotationLeg1 = \"1\" then spreadCurrencyLeg1 exists else spreadCurrencyLeg1 is absent) and (if [\"Credit\", \"InterestRate\", \"Equity\", \"Commodity\"] any = cftcGuidebook -> assetClass and spreadNotationLeg2 = \"1\" then spreadCurrencyLeg2 exists else spreadCurrencyLeg2 is absent)";
	
	class Default implements CFTCPart45TransactionReportSpreadCurrencyCondition {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart45TransactionReport cFTCPart45TransactionReport) {
			ComparisonResult result = executeDataRule(cFTCPart45TransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCPart45TransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCPart45TransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(CFTCPart45TransactionReport cFTCPart45TransactionReport) {
			try {
				final ComparisonResult ifThenElseResult0;
				if (areEqual(MapperC.<String>of(MapperS.of("Credit"), MapperS.of("InterestRate"), MapperS.of("Equity"), MapperS.of("Commodity")), MapperS.of(cFTCPart45TransactionReport).<CFTCGuidebookPart45>map("getCftcGuidebook", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getCftcGuidebook()).<String>map("getAssetClass", cFTCGuidebookPart45 -> cFTCGuidebookPart45.getAssetClass()), CardinalityOperator.Any).and(areEqual(MapperS.of(cFTCPart45TransactionReport).<String>map("getSpreadNotationLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getSpreadNotationLeg1()), MapperS.of("1"), CardinalityOperator.All)).getOrDefault(false)) {
					ifThenElseResult0 = exists(MapperS.of(cFTCPart45TransactionReport).<ISOCurrencyCodeEnum>map("getSpreadCurrencyLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getSpreadCurrencyLeg1()));
				} else {
					ifThenElseResult0 = notExists(MapperS.of(cFTCPart45TransactionReport).<ISOCurrencyCodeEnum>map("getSpreadCurrencyLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getSpreadCurrencyLeg1()));
				}
				final ComparisonResult ifThenElseResult1;
				if (areEqual(MapperC.<String>of(MapperS.of("Credit"), MapperS.of("InterestRate"), MapperS.of("Equity"), MapperS.of("Commodity")), MapperS.of(cFTCPart45TransactionReport).<CFTCGuidebookPart45>map("getCftcGuidebook", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getCftcGuidebook()).<String>map("getAssetClass", cFTCGuidebookPart45 -> cFTCGuidebookPart45.getAssetClass()), CardinalityOperator.Any).and(areEqual(MapperS.of(cFTCPart45TransactionReport).<String>map("getSpreadNotationLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getSpreadNotationLeg2()), MapperS.of("1"), CardinalityOperator.All)).getOrDefault(false)) {
					ifThenElseResult1 = exists(MapperS.of(cFTCPart45TransactionReport).<ISOCurrencyCodeEnum>map("getSpreadCurrencyLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getSpreadCurrencyLeg2()));
				} else {
					ifThenElseResult1 = notExists(MapperS.of(cFTCPart45TransactionReport).<ISOCurrencyCodeEnum>map("getSpreadCurrencyLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getSpreadCurrencyLeg2()));
				}
				return ifThenElseResult0.and(ifThenElseResult1);
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements CFTCPart45TransactionReportSpreadCurrencyCondition {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart45TransactionReport cFTCPart45TransactionReport) {
			return Collections.emptyList();
		}
	}
}
