package drr.regulation.cftc.rewrite.validation.exists;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.common.collect.ImmutableMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.cftc.rewrite.CFTCGuidebookPart45;
import drr.regulation.cftc.rewrite.CFTCNonReportablePart45;
import drr.regulation.cftc.rewrite.CFTCPart45TransactionReport;
import drr.regulation.cftc.rewrite.ClearingExceptionsAndExemptionsCounterparty1Report;
import drr.regulation.cftc.rewrite.ClearingExceptionsAndExemptionsCounterparty2Report;
import drr.regulation.cftc.rewrite.ClearingSwapUSIsReport;
import drr.regulation.cftc.rewrite.ClearingSwapUTIsReport;
import drr.regulation.cftc.rewrite.NotionalAmountScheduleLeg1Report;
import drr.regulation.cftc.rewrite.NotionalAmountScheduleLeg2Report;
import drr.regulation.cftc.rewrite.OtherPaymentReport;
import iso20022.auth030.esma.InterestComputationMethod4Code;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;

public class CFTCPart45TransactionReportOnlyExistsValidator implements ValidatorWithArg<CFTCPart45TransactionReport, Set<String>> {

	/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
	@Override
	public <T2 extends CFTCPart45TransactionReport> ValidationResult<CFTCPart45TransactionReport> validate(RosettaPath path, T2 o, Set<String> fields) {
		Map<String, Boolean> fieldExistenceMap = ImmutableMap.<String, Boolean>builder()
				.put("cleared", ExistenceChecker.isSet((String) o.getCleared()))
				.put("centralCounterparty", ExistenceChecker.isSet((String) o.getCentralCounterparty()))
				.put("clearingAccountOrigin", ExistenceChecker.isSet((String) o.getClearingAccountOrigin()))
				.put("clearingMember", ExistenceChecker.isSet((String) o.getClearingMember()))
				.put("clearingSwapUSIs", ExistenceChecker.isSet((List<? extends ClearingSwapUSIsReport>) o.getClearingSwapUSIs()))
				.put("clearingSwapUTIs", ExistenceChecker.isSet((List<? extends ClearingSwapUTIsReport>) o.getClearingSwapUTIs()))
				.put("originalSwapUSI", ExistenceChecker.isSet((String) o.getOriginalSwapUSI()))
				.put("originalSwapUTI", ExistenceChecker.isSet((String) o.getOriginalSwapUTI()))
				.put("originalSwapSDRIdentifier", ExistenceChecker.isSet((String) o.getOriginalSwapSDRIdentifier()))
				.put("clearingReceiptTimestamp", ExistenceChecker.isSet((ZonedDateTime) o.getClearingReceiptTimestamp()))
				.put("clearingExceptionsAndExemptionsCounterparty1", ExistenceChecker.isSet((List<? extends ClearingExceptionsAndExemptionsCounterparty1Report>) o.getClearingExceptionsAndExemptionsCounterparty1()))
				.put("clearingExceptionsAndExemptionsCounterparty2", ExistenceChecker.isSet((List<? extends ClearingExceptionsAndExemptionsCounterparty2Report>) o.getClearingExceptionsAndExemptionsCounterparty2()))
				.put("counterparty1", ExistenceChecker.isSet((String) o.getCounterparty1()))
				.put("counterparty2", ExistenceChecker.isSet((String) o.getCounterparty2()))
				.put("counterparty2IdentifierSource", ExistenceChecker.isSet((String) o.getCounterparty2IdentifierSource()))
				.put("counterparty1FinancialEntityIndicator", ExistenceChecker.isSet((Boolean) o.getCounterparty1FinancialEntityIndicator()))
				.put("counterparty2FinancialEntityIndicator", ExistenceChecker.isSet((Boolean) o.getCounterparty2FinancialEntityIndicator()))
				.put("buyerIdentifier", ExistenceChecker.isSet((String) o.getBuyerIdentifier()))
				.put("sellerIdentifier", ExistenceChecker.isSet((String) o.getSellerIdentifier()))
				.put("payerIdentifierLeg1", ExistenceChecker.isSet((String) o.getPayerIdentifierLeg1()))
				.put("payerIdentifierLeg2", ExistenceChecker.isSet((String) o.getPayerIdentifierLeg2()))
				.put("receiverIdentifierLeg1", ExistenceChecker.isSet((String) o.getReceiverIdentifierLeg1()))
				.put("receiverIdentifierLeg2", ExistenceChecker.isSet((String) o.getReceiverIdentifierLeg2()))
				.put("submitterIdentifier", ExistenceChecker.isSet((String) o.getSubmitterIdentifier()))
				.put("counterparty1FederalEntityIndicator", ExistenceChecker.isSet((Boolean) o.getCounterparty1FederalEntityIndicator()))
				.put("counterparty2FederalEntityIndicator", ExistenceChecker.isSet((Boolean) o.getCounterparty2FederalEntityIndicator()))
				.put("customBasketIndicator", ExistenceChecker.isSet((Boolean) o.getCustomBasketIndicator()))
				.put("actionType", ExistenceChecker.isSet((String) o.getActionType()))
				.put("eventType", ExistenceChecker.isSet((String) o.getEventType()))
				.put("amendmentIndicator", ExistenceChecker.isSet((Boolean) o.getAmendmentIndicator()))
				.put("eventIdentifier", ExistenceChecker.isSet((String) o.getEventIdentifier()))
				.put("eventTimestamp", ExistenceChecker.isSet((ZonedDateTime) o.getEventTimestamp()))
				.put("notionalAmountLeg1", ExistenceChecker.isSet((BigDecimal) o.getNotionalAmountLeg1()))
				.put("notionalAmountLeg2", ExistenceChecker.isSet((BigDecimal) o.getNotionalAmountLeg2()))
				.put("notionalCurrencyLeg1", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getNotionalCurrencyLeg1()))
				.put("notionalCurrencyLeg2", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getNotionalCurrencyLeg2()))
				.put("notionalAmountScheduleLeg1", ExistenceChecker.isSet((List<? extends NotionalAmountScheduleLeg1Report>) o.getNotionalAmountScheduleLeg1()))
				.put("notionalAmountScheduleLeg2", ExistenceChecker.isSet((List<? extends NotionalAmountScheduleLeg2Report>) o.getNotionalAmountScheduleLeg2()))
				.put("callAmount", ExistenceChecker.isSet((BigDecimal) o.getCallAmount()))
				.put("callCurrency", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getCallCurrency()))
				.put("putAmount", ExistenceChecker.isSet((BigDecimal) o.getPutAmount()))
				.put("putCurrency", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getPutCurrency()))
				.put("notionalQuantityLeg1", ExistenceChecker.isSet((BigDecimal) o.getNotionalQuantityLeg1()))
				.put("notionalQuantityLeg2", ExistenceChecker.isSet((BigDecimal) o.getNotionalQuantityLeg2()))
				.put("quantityFrequencyLeg1", ExistenceChecker.isSet((String) o.getQuantityFrequencyLeg1()))
				.put("quantityFrequencyLeg2", ExistenceChecker.isSet((String) o.getQuantityFrequencyLeg2()))
				.put("quantityFrequencyMultiplierLeg1", ExistenceChecker.isSet((Integer) o.getQuantityFrequencyMultiplierLeg1()))
				.put("quantityFrequencyMultiplierLeg2", ExistenceChecker.isSet((Integer) o.getQuantityFrequencyMultiplierLeg2()))
				.put("quantityUnitOfMeasureLeg1", ExistenceChecker.isSet((String) o.getQuantityUnitOfMeasureLeg1()))
				.put("quantityUnitOfMeasureLeg2", ExistenceChecker.isSet((String) o.getQuantityUnitOfMeasureLeg2()))
				.put("totalNotionalQuantityLeg1", ExistenceChecker.isSet((BigDecimal) o.getTotalNotionalQuantityLeg1()))
				.put("totalNotionalQuantityLeg2", ExistenceChecker.isSet((BigDecimal) o.getTotalNotionalQuantityLeg2()))
				.put("packageIndicator", ExistenceChecker.isSet((Boolean) o.getPackageIndicator()))
				.put("packageIdentifier", ExistenceChecker.isSet((String) o.getPackageIdentifier()))
				.put("packageTransactionPrice", ExistenceChecker.isSet((BigDecimal) o.getPackageTransactionPrice()))
				.put("packageTransactionPriceCurrency", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getPackageTransactionPriceCurrency()))
				.put("packageTransactionPriceNotation", ExistenceChecker.isSet((String) o.getPackageTransactionPriceNotation()))
				.put("packageTransactionSpread", ExistenceChecker.isSet((BigDecimal) o.getPackageTransactionSpread()))
				.put("packageTransactionSpreadCurrency", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getPackageTransactionSpreadCurrency()))
				.put("packageTransactionSpreadNotation", ExistenceChecker.isSet((String) o.getPackageTransactionSpreadNotation()))
				.put("fixedRateDayCountConventionLeg1", ExistenceChecker.isSet((InterestComputationMethod4Code) o.getFixedRateDayCountConventionLeg1()))
				.put("fixedRateDayCountConventionLeg2", ExistenceChecker.isSet((InterestComputationMethod4Code) o.getFixedRateDayCountConventionLeg2()))
				.put("floatingRateDayCountConventionLeg1", ExistenceChecker.isSet((InterestComputationMethod4Code) o.getFloatingRateDayCountConventionLeg1()))
				.put("floatingRateDayCountConventionLeg2", ExistenceChecker.isSet((InterestComputationMethod4Code) o.getFloatingRateDayCountConventionLeg2()))
				.put("fixingDateLeg1", ExistenceChecker.isSet((Date) o.getFixingDateLeg1()))
				.put("fixingDateLeg2", ExistenceChecker.isSet((Date) o.getFixingDateLeg2()))
				.put("floatingRateResetFrequencyPeriodLeg1", ExistenceChecker.isSet((String) o.getFloatingRateResetFrequencyPeriodLeg1()))
				.put("floatingRateResetFrequencyPeriodLeg2", ExistenceChecker.isSet((String) o.getFloatingRateResetFrequencyPeriodLeg2()))
				.put("floatingRateResetFrequencyPeriodMultiplierLeg1", ExistenceChecker.isSet((Integer) o.getFloatingRateResetFrequencyPeriodMultiplierLeg1()))
				.put("floatingRateResetFrequencyPeriodMultiplierLeg2", ExistenceChecker.isSet((Integer) o.getFloatingRateResetFrequencyPeriodMultiplierLeg2()))
				.put("otherPayment", ExistenceChecker.isSet((List<? extends OtherPaymentReport>) o.getOtherPayment()))
				.put("fixedRatePaymentFrequencyPeriodLeg1", ExistenceChecker.isSet((String) o.getFixedRatePaymentFrequencyPeriodLeg1()))
				.put("fixedRatePaymentFrequencyPeriodLeg2", ExistenceChecker.isSet((String) o.getFixedRatePaymentFrequencyPeriodLeg2()))
				.put("floatingRatePaymentFrequencyPeriodLeg1", ExistenceChecker.isSet((String) o.getFloatingRatePaymentFrequencyPeriodLeg1()))
				.put("floatingRatePaymentFrequencyPeriodLeg2", ExistenceChecker.isSet((String) o.getFloatingRatePaymentFrequencyPeriodLeg2()))
				.put("fixedRatePaymentFrequencyPeriodMultiplierLeg1", ExistenceChecker.isSet((Integer) o.getFixedRatePaymentFrequencyPeriodMultiplierLeg1()))
				.put("fixedRatePaymentFrequencyPeriodMultiplierLeg2", ExistenceChecker.isSet((Integer) o.getFixedRatePaymentFrequencyPeriodMultiplierLeg2()))
				.put("floatingRatePaymentFrequencyPeriodMultiplierLeg1", ExistenceChecker.isSet((Integer) o.getFloatingRatePaymentFrequencyPeriodMultiplierLeg1()))
				.put("floatingRatePaymentFrequencyPeriodMultiplierLeg2", ExistenceChecker.isSet((Integer) o.getFloatingRatePaymentFrequencyPeriodMultiplierLeg2()))
				.put("exchangeRateLeg1", ExistenceChecker.isSet((BigDecimal) o.getExchangeRateLeg1()))
				.put("exchangeRateBasis", ExistenceChecker.isSet((String) o.getExchangeRateBasis()))
				.put("fixedRateLeg1", ExistenceChecker.isSet((BigDecimal) o.getFixedRateLeg1()))
				.put("fixedRateLeg2", ExistenceChecker.isSet((BigDecimal) o.getFixedRateLeg2()))
				.put("postPricedSwapIndicator", ExistenceChecker.isSet((Boolean) o.getPostPricedSwapIndicator()))
				.put("price", ExistenceChecker.isSet((BigDecimal) o.getPrice()))
				.put("priceCurrency", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getPriceCurrency()))
				.put("priceNotation", ExistenceChecker.isSet((String) o.getPriceNotation()))
				.put("priceUnitOfMeasure", ExistenceChecker.isSet((String) o.getPriceUnitOfMeasure()))
				.put("spreadLeg1", ExistenceChecker.isSet((BigDecimal) o.getSpreadLeg1()))
				.put("spreadLeg2", ExistenceChecker.isSet((BigDecimal) o.getSpreadLeg2()))
				.put("spreadCurrencyLeg1", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getSpreadCurrencyLeg1()))
				.put("spreadCurrencyLeg2", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getSpreadCurrencyLeg2()))
				.put("spreadNotationLeg1", ExistenceChecker.isSet((String) o.getSpreadNotationLeg1()))
				.put("spreadNotationLeg2", ExistenceChecker.isSet((String) o.getSpreadNotationLeg2()))
				.put("strikePrice", ExistenceChecker.isSet((BigDecimal) o.getStrikePrice()))
				.put("strikePriceCurrency", ExistenceChecker.isSet((String) o.getStrikePriceCurrency()))
				.put("strikePriceNotation", ExistenceChecker.isSet((String) o.getStrikePriceNotation()))
				.put("optionPremiumAmount", ExistenceChecker.isSet((BigDecimal) o.getOptionPremiumAmount()))
				.put("optionPremiumCurrency", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getOptionPremiumCurrency()))
				.put("optionPremiumPaymentDate", ExistenceChecker.isSet((Date) o.getOptionPremiumPaymentDate()))
				.put("firstExerciseDate", ExistenceChecker.isSet((Date) o.getFirstExerciseDate()))
				.put("cDSIndexAttachmentPoint", ExistenceChecker.isSet((BigDecimal) o.getCDSIndexAttachmentPoint()))
				.put("cDSIndexDetachmentPoint", ExistenceChecker.isSet((BigDecimal) o.getCDSIndexDetachmentPoint()))
				.put("indexFactor", ExistenceChecker.isSet((BigDecimal) o.getIndexFactor()))
				.put("embeddedOptionType", ExistenceChecker.isSet((String) o.getEmbeddedOptionType()))
				.put("uniqueProductIdentifier", ExistenceChecker.isSet((String) o.getUniqueProductIdentifier()))
				.put("finalContractualSettlementDate", ExistenceChecker.isSet((Date) o.getFinalContractualSettlementDate()))
				.put("settlementCurrencyLeg1", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getSettlementCurrencyLeg1()))
				.put("settlementCurrencyLeg2", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getSettlementCurrencyLeg2()))
				.put("settlementLocationLeg1", ExistenceChecker.isSet((String) o.getSettlementLocationLeg1()))
				.put("settlementLocationLeg2", ExistenceChecker.isSet((String) o.getSettlementLocationLeg2()))
				.put("allocationIndicator", ExistenceChecker.isSet((String) o.getAllocationIndicator()))
				.put("nonStandardizedTermIndicator", ExistenceChecker.isSet((Boolean) o.getNonStandardizedTermIndicator()))
				.put("blockTradeElectionIndicator", ExistenceChecker.isSet((Boolean) o.getBlockTradeElectionIndicator()))
				.put("effectiveDate", ExistenceChecker.isSet((Date) o.getEffectiveDate()))
				.put("expirationDate", ExistenceChecker.isSet((Date) o.getExpirationDate()))
				.put("executionTimestamp", ExistenceChecker.isSet((ZonedDateTime) o.getExecutionTimestamp()))
				.put("reportingTimestamp", ExistenceChecker.isSet((ZonedDateTime) o.getReportingTimestamp()))
				.put("platformIdentifier", ExistenceChecker.isSet((String) o.getPlatformIdentifier()))
				.put("primeBrokerageTransactionIndicator", ExistenceChecker.isSet((Boolean) o.getPrimeBrokerageTransactionIndicator()))
				.put("priorUSI", ExistenceChecker.isSet((String) o.getPriorUSI()))
				.put("priorUTI", ExistenceChecker.isSet((String) o.getPriorUTI()))
				.put("uniqueSwapIdentifier", ExistenceChecker.isSet((String) o.getUniqueSwapIdentifier()))
				.put("uniqueTransactionIdentifier", ExistenceChecker.isSet((String) o.getUniqueTransactionIdentifier()))
				.put("jurisdiction", ExistenceChecker.isSet((String) o.getJurisdiction()))
				.put("newSDRIdentifier", ExistenceChecker.isSet((String) o.getNewSDRIdentifier()))
				.put("initialMarginCollateralPortfolioCode", ExistenceChecker.isSet((String) o.getInitialMarginCollateralPortfolioCode()))
				.put("variationMarginCollateralPortfolioCode", ExistenceChecker.isSet((String) o.getVariationMarginCollateralPortfolioCode()))
				.put("cftcGuidebook", ExistenceChecker.isSet((CFTCGuidebookPart45) o.getCftcGuidebook()))
				.put("nonReportable", ExistenceChecker.isSet((CFTCNonReportablePart45) o.getNonReportable()))
				.build();
		
		// Find the fields that are set
		Set<String> setFields = fieldExistenceMap.entrySet().stream()
				.filter(Map.Entry::getValue)
				.map(Map.Entry::getKey)
				.collect(Collectors.toSet());
		
		if (setFields.equals(fields)) {
			return success("CFTCPart45TransactionReport", ValidationResult.ValidationType.ONLY_EXISTS, "CFTCPart45TransactionReport", path, "");
		}
		return failure("CFTCPart45TransactionReport", ValidationResult.ValidationType.ONLY_EXISTS, "CFTCPart45TransactionReport", path, "",
				String.format("[%s] should only be set.  Set fields: %s", fields, setFields));
	}
}
