package drr.regulation.cftc.tr.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ExecutionVenueTypeEnum;
import drr.regulation.common.PartyInformation;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.ReportingRegime;
import drr.regulation.common.SupervisoryBodyEnum;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.metafields.FieldWithMetaSupervisoryBodyEnum;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(SefOrDcmAnonymousExecutionIndicatorRule.SefOrDcmAnonymousExecutionIndicatorRuleDefault.class)
public abstract class SefOrDcmAnonymousExecutionIndicatorRule implements ReportFunction<TransactionReportInstruction, Boolean> {

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Boolean evaluate(TransactionReportInstruction input) {
		Boolean output = doEvaluate(input);
		
		return output;
	}

	protected abstract Boolean doEvaluate(TransactionReportInstruction input);

	public static class SefOrDcmAnonymousExecutionIndicatorRuleDefault extends SefOrDcmAnonymousExecutionIndicatorRule {
		@Override
		protected Boolean doEvaluate(TransactionReportInstruction input) {
			Boolean output = null;
			return assignOutput(output, input);
		}
		
		protected Boolean assignOutput(Boolean output, TransactionReportInstruction input) {
			final MapperS<ReportableInformation> thenArg = MapperS.of(input)
				.mapSingleToItem(item -> item.<ReportableInformation>map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()));
			output = thenArg
				.mapSingleToItem(item -> {
					final MapperC<PartyInformation> _thenArg = item.<PartyInformation>mapC("getPartyInformation", reportableInformation -> reportableInformation.getPartyInformation())
						.filterItemNullSafe(_item -> areEqual(_item.<ReportingRegime>mapC("getRegimeInformation", partyInformation -> partyInformation.getRegimeInformation()).<FieldWithMetaSupervisoryBodyEnum>map("getSupervisoryBody", reportingRegime -> reportingRegime.getSupervisoryBody()).<SupervisoryBodyEnum>map("Type coercion", fieldWithMetaSupervisoryBodyEnum -> fieldWithMetaSupervisoryBodyEnum.getValue()), MapperS.of(SupervisoryBodyEnum.CFTC), CardinalityOperator.Any).get());
					if (ComparisonResult.of(exists(_thenArg).asMapper()).and(areEqual(item.<ExecutionVenueTypeEnum>map("getExecutionVenueType", reportableInformation -> reportableInformation.getExecutionVenueType()), MapperS.of(ExecutionVenueTypeEnum.SEF), CardinalityOperator.All).or(areEqual(item.<ExecutionVenueTypeEnum>map("getExecutionVenueType", reportableInformation -> reportableInformation.getExecutionVenueType()), MapperS.of(ExecutionVenueTypeEnum.DCM), CardinalityOperator.All))).getOrDefault(false)) {
						if (exists(item.<Boolean>map("getSefOrDcmAnonymousIndicator", reportableInformation -> reportableInformation.getSefOrDcmAnonymousIndicator())).getOrDefault(false)) {
							return item.<Boolean>map("getSefOrDcmAnonymousIndicator", reportableInformation -> reportableInformation.getSefOrDcmAnonymousIndicator());
						}
						return MapperS.of(false);
					}
					return MapperS.of(false);
				}).get();
			
			return output;
		}
	}
}
