package drr.regulation.common;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.regulation.common.meta.ValuationReportInstructionMeta;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * Specifies a reportable valuation with with a single reporting side.
 * @version 5.50.0
 */
@RosettaDataType(value="ValuationReportInstruction", builder=ValuationReportInstruction.ValuationReportInstructionBuilderImpl.class, version="5.50.0")
@RuneDataType(value="ValuationReportInstruction", model="drr", builder=ValuationReportInstruction.ValuationReportInstructionBuilderImpl.class, version="5.50.0")
public interface ValuationReportInstruction extends ReportableValuation {

	ValuationReportInstructionMeta metaData = new ValuationReportInstructionMeta();

	/*********************** Getter Methods  ***********************/
	ReportingSide getReportingSide();

	/*********************** Build Methods  ***********************/
	ValuationReportInstruction build();
	
	ValuationReportInstruction.ValuationReportInstructionBuilder toBuilder();
	
	static ValuationReportInstruction.ValuationReportInstructionBuilder builder() {
		return new ValuationReportInstruction.ValuationReportInstructionBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends ValuationReportInstruction> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends ValuationReportInstruction> getType() {
		return ValuationReportInstruction.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processRosetta(path.newSubPath("valuationDetails"), processor, ValuationDetails.class, getValuationDetails());
		processRosetta(path.newSubPath("reportableInformation"), processor, ReportableInformation.class, getReportableInformation());
		processRosetta(path.newSubPath("reportingSide"), processor, ReportingSide.class, getReportingSide());
	}
	

	/*********************** Builder Interface  ***********************/
	interface ValuationReportInstructionBuilder extends ValuationReportInstruction, ReportableValuation.ReportableValuationBuilder {
		ReportingSide.ReportingSideBuilder getOrCreateReportingSide();
		@Override
		ReportingSide.ReportingSideBuilder getReportingSide();
		@Override
		ValuationReportInstruction.ValuationReportInstructionBuilder setValuationDetails(ValuationDetails valuationDetails);
		@Override
		ValuationReportInstruction.ValuationReportInstructionBuilder setReportableInformation(ReportableInformation reportableInformation);
		ValuationReportInstruction.ValuationReportInstructionBuilder setReportingSide(ReportingSide reportingSide);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processRosetta(path.newSubPath("valuationDetails"), processor, ValuationDetails.ValuationDetailsBuilder.class, getValuationDetails());
			processRosetta(path.newSubPath("reportableInformation"), processor, ReportableInformation.ReportableInformationBuilder.class, getReportableInformation());
			processRosetta(path.newSubPath("reportingSide"), processor, ReportingSide.ReportingSideBuilder.class, getReportingSide());
		}
		

		ValuationReportInstruction.ValuationReportInstructionBuilder prune();
	}

	/*********************** Immutable Implementation of ValuationReportInstruction  ***********************/
	class ValuationReportInstructionImpl extends ReportableValuation.ReportableValuationImpl implements ValuationReportInstruction {
		private final ReportingSide reportingSide;
		
		protected ValuationReportInstructionImpl(ValuationReportInstruction.ValuationReportInstructionBuilder builder) {
			super(builder);
			this.reportingSide = ofNullable(builder.getReportingSide()).map(f->f.build()).orElse(null);
		}
		
		@Override
		@RosettaAttribute(value="reportingSide", isRequired=true)
		@RuneAttribute(value="reportingSide", isRequired=true)
		public ReportingSide getReportingSide() {
			return reportingSide;
		}
		
		@Override
		public ValuationReportInstruction build() {
			return this;
		}
		
		@Override
		public ValuationReportInstruction.ValuationReportInstructionBuilder toBuilder() {
			ValuationReportInstruction.ValuationReportInstructionBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(ValuationReportInstruction.ValuationReportInstructionBuilder builder) {
			super.setBuilderFields(builder);
			ofNullable(getReportingSide()).ifPresent(builder::setReportingSide);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
			if (!super.equals(o)) return false;
		
			ValuationReportInstruction _that = getType().cast(o);
		
			if (!Objects.equals(reportingSide, _that.getReportingSide())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = super.hashCode();
			_result = 31 * _result + (reportingSide != null ? reportingSide.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "ValuationReportInstruction {" +
				"reportingSide=" + this.reportingSide +
			'}' + " " + super.toString();
		}
	}

	/*********************** Builder Implementation of ValuationReportInstruction  ***********************/
	class ValuationReportInstructionBuilderImpl extends ReportableValuation.ReportableValuationBuilderImpl implements ValuationReportInstruction.ValuationReportInstructionBuilder {
	
		protected ReportingSide.ReportingSideBuilder reportingSide;
		
		@Override
		@RosettaAttribute(value="reportingSide", isRequired=true)
		@RuneAttribute(value="reportingSide", isRequired=true)
		public ReportingSide.ReportingSideBuilder getReportingSide() {
			return reportingSide;
		}
		
		@Override
		public ReportingSide.ReportingSideBuilder getOrCreateReportingSide() {
			ReportingSide.ReportingSideBuilder result;
			if (reportingSide!=null) {
				result = reportingSide;
			}
			else {
				result = reportingSide = ReportingSide.builder();
			}
			
			return result;
		}
		
		@RosettaAttribute("valuationDetails")
		@RuneAttribute("valuationDetails")
		@Override
		public ValuationReportInstruction.ValuationReportInstructionBuilder setValuationDetails(ValuationDetails _valuationDetails) {
			this.valuationDetails = _valuationDetails == null ? null : _valuationDetails.toBuilder();
			return this;
		}
		
		@RosettaAttribute(value="reportableInformation", isRequired=true)
		@RuneAttribute(value="reportableInformation", isRequired=true)
		@Override
		public ValuationReportInstruction.ValuationReportInstructionBuilder setReportableInformation(ReportableInformation _reportableInformation) {
			this.reportableInformation = _reportableInformation == null ? null : _reportableInformation.toBuilder();
			return this;
		}
		
		@RosettaAttribute(value="reportingSide", isRequired=true)
		@RuneAttribute(value="reportingSide", isRequired=true)
		@Override
		public ValuationReportInstruction.ValuationReportInstructionBuilder setReportingSide(ReportingSide _reportingSide) {
			this.reportingSide = _reportingSide == null ? null : _reportingSide.toBuilder();
			return this;
		}
		
		@Override
		public ValuationReportInstruction build() {
			return new ValuationReportInstruction.ValuationReportInstructionImpl(this);
		}
		
		@Override
		public ValuationReportInstruction.ValuationReportInstructionBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public ValuationReportInstruction.ValuationReportInstructionBuilder prune() {
			super.prune();
			if (reportingSide!=null && !reportingSide.prune().hasData()) reportingSide = null;
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (super.hasData()) return true;
			if (getReportingSide()!=null && getReportingSide().hasData()) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public ValuationReportInstruction.ValuationReportInstructionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			super.merge(other, merger);
			ValuationReportInstruction.ValuationReportInstructionBuilder o = (ValuationReportInstruction.ValuationReportInstructionBuilder) other;
			
			merger.mergeRosetta(getReportingSide(), o.getReportingSide(), this::setReportingSide);
			
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
			if (!super.equals(o)) return false;
		
			ValuationReportInstruction _that = getType().cast(o);
		
			if (!Objects.equals(reportingSide, _that.getReportingSide())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = super.hashCode();
			_result = 31 * _result + (reportingSide != null ? reportingSide.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "ValuationReportInstructionBuilder {" +
				"reportingSide=" + this.reportingSide +
			'}' + " " + super.toString();
		}
	}
}
