package drr.regulation.common.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(AdjustPeriod.AdjustPeriodDefault.class)
public abstract class AdjustPeriod implements RosettaFunction {

	/**
	* @param period 
	* @param periodMultiplier 
	* @return periodValue 
	*/
	public String evaluate(String period, BigDecimal periodMultiplier) {
		String periodValue = doEvaluate(period, periodMultiplier);
		
		return periodValue;
	}

	protected abstract String doEvaluate(String period, BigDecimal periodMultiplier);

	public static class AdjustPeriodDefault extends AdjustPeriod {
		@Override
		protected String doEvaluate(String period, BigDecimal periodMultiplier) {
			String periodValue = null;
			return assignOutput(periodValue, period, periodMultiplier);
		}
		
		protected String assignOutput(String periodValue, String period, BigDecimal periodMultiplier) {
			if (areEqual(MapperS.of(period), MapperS.of("MNTH"), CardinalityOperator.All).and(areEqual(MapperS.of(periodMultiplier), MapperS.of(BigDecimal.valueOf(12)), CardinalityOperator.All)).getOrDefault(false)) {
				periodValue = "YEAR";
			} else {
				periodValue = period;
			}
			
			return periodValue;
		}
	}
}
