package drr.regulation.common.functions;

import cdm.observable.asset.Observable;
import cdm.product.common.settlement.PriceQuantity;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(CommodityFixedPriceQuantity.CommodityFixedPriceQuantityDefault.class)
public abstract class CommodityFixedPriceQuantity implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;

	/**
	* @param tradeLot 
	* @return fixedLegPriceQuantity 
	*/
	public PriceQuantity evaluate(TradeLot tradeLot) {
		PriceQuantity.PriceQuantityBuilder fixedLegPriceQuantityBuilder = doEvaluate(tradeLot);
		
		final PriceQuantity fixedLegPriceQuantity;
		if (fixedLegPriceQuantityBuilder == null) {
			fixedLegPriceQuantity = null;
		} else {
			fixedLegPriceQuantity = fixedLegPriceQuantityBuilder.build();
			objectValidator.validate(PriceQuantity.class, fixedLegPriceQuantity);
		}
		
		return fixedLegPriceQuantity;
	}

	protected abstract PriceQuantity.PriceQuantityBuilder doEvaluate(TradeLot tradeLot);

	public static class CommodityFixedPriceQuantityDefault extends CommodityFixedPriceQuantity {
		@Override
		protected PriceQuantity.PriceQuantityBuilder doEvaluate(TradeLot tradeLot) {
			PriceQuantity.PriceQuantityBuilder fixedLegPriceQuantity = PriceQuantity.builder();
			return assignOutput(fixedLegPriceQuantity, tradeLot);
		}
		
		protected PriceQuantity.PriceQuantityBuilder assignOutput(PriceQuantity.PriceQuantityBuilder fixedLegPriceQuantity, TradeLot tradeLot) {
			final MapperC<PriceQuantity> thenArg = MapperS.of(tradeLot).<PriceQuantity>mapC("getPriceQuantity", _tradeLot -> _tradeLot.getPriceQuantity())
				.filterItemNullSafe(item -> notExists(item.<Observable>map("getObservable", priceQuantity -> priceQuantity.getObservable())).get());
			fixedLegPriceQuantity = toBuilder(MapperS.of(thenArg.get()).get());
			
			return Optional.ofNullable(fixedLegPriceQuantity)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
