package drr.regulation.common.functions;

import com.rosetta.model.lib.records.Date;
import drr.regulation.common.QuantityReportablePeriod;

import java.time.LocalDate;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

import static drr.regulation.common.QuantityReportablePeriod.QuantityReportablePeriodBuilder;

public class Create_ContinuousQuantityScheduleImpl extends Create_ContinuousQuantitySchedule {
    @Override
    protected List<QuantityReportablePeriodBuilder> doEvaluate(List<? extends QuantityReportablePeriod> reportablePeriods, Date endDate) {
        if (reportablePeriods == null || endDate == null) {
            return null;
        }
        LocalDate localEndDate = endDate.toLocalDate();

        // First sort based on start date
        List<? extends QuantityReportablePeriod> sortedPeriods = reportablePeriods.stream()
                .sorted(Comparator.comparing(QuantityReportablePeriod::getPeriodEffectiveDate))
                .collect(Collectors.toList());

        return IntStream.range(0, sortedPeriods.size()).mapToObj(i -> {
            QuantityReportablePeriod QuantityReportablePeriod = sortedPeriods.get(i);
            QuantityReportablePeriod.QuantityReportablePeriodBuilder reportablePeriodBuilder = toBuilder(QuantityReportablePeriod);

            LocalDate computedEndDate;
            //This is the last reportable Period
            if (i == sortedPeriods.size() - 1) {
                computedEndDate = localEndDate;
            } else {
                computedEndDate = sortedPeriods.get(i + 1).getPeriodEffectiveDate().toLocalDate().minusDays(1);
            }

            if (QuantityReportablePeriod.getPeriodEndDate() == null || QuantityReportablePeriod.getPeriodEndDate().toLocalDate().isBefore(localEndDate)) {
                reportablePeriodBuilder.setPeriodEndDate(Date.of(computedEndDate));
            }
            return reportablePeriodBuilder;
        }).collect(Collectors.toList());
    }

}
