package drr.regulation.common.functions;

import cdm.product.asset.CommodityPayout;
import cdm.product.asset.CreditDefaultPayout;
import cdm.product.qualification.functions.Qualify_AssetClass_InterestRate;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_Basis;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_FixedFloat;
import cdm.product.qualification.functions.Qualify_Commodity_Swaption;
import cdm.product.qualification.functions.Qualify_InterestRate_Forward_Debt;
import cdm.product.qualification.functions.Qualify_InterestRate_Option_Swaption;
import cdm.product.template.FixedPricePayout;
import cdm.product.template.ForwardPayout;
import cdm.product.template.OptionPayout;
import cdm.product.template.Payout;
import cdm.product.template.PerformancePayout;
import cdm.product.template.Product;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.PayoutLegWithAuxiliary;
import drr.regulation.common.ReportableInformation;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(PayoutLeg1.PayoutLeg1Default.class)
public abstract class PayoutLeg1 implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected CommodityBasisLegWithNoSpread commodityBasisLegWithNoSpread;
	@Inject protected CommodityLeg1 commodityLeg1;
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected FXLeg1 fXLeg1;
	@Inject protected FXSwapLeg1 fXSwapLeg1;
	@Inject protected InterestRateLeg1 interestRateLeg1;
	@Inject protected InterestRateLeg2FixedFloatSingleCurrency interestRateLeg2FixedFloatSingleCurrency;
	@Inject protected IsCommodityFixedPriceForward isCommodityFixedPriceForward;
	@Inject protected IsCommodityFloatingPriceForward isCommodityFloatingPriceForward;
	@Inject protected IsCommodityOption isCommodityOption;
	@Inject protected IsCreditDefaultSwap isCreditDefaultSwap;
	@Inject protected IsCreditSwaption isCreditSwaption;
	@Inject protected IsEquity isEquity;
	@Inject protected IsEquityForward isEquityForward;
	@Inject protected IsEquityOption isEquityOption;
	@Inject protected IsFXForward isFXForward;
	@Inject protected IsFXOption isFXOption;
	@Inject protected IsFXSwap isFXSwap;
	@Inject protected IsFixedFloatZeroCouponSwapKnownAmount isFixedFloatZeroCouponSwapKnownAmount;
	@Inject protected IsInterestRateDebtOption isInterestRateDebtOption;
	@Inject protected IsProductETD isProductETD;
	@Inject protected IsSingleCommodityPayoutProduct isSingleCommodityPayoutProduct;
	@Inject protected IsTotalReturnSwapDebtUnderlier isTotalReturnSwapDebtUnderlier;
	@Inject protected LastAvailableSpotPrice lastAvailableSpotPrice;
	@Inject protected Qualify_AssetClass_InterestRate qualify_AssetClass_InterestRate;
	@Inject protected Qualify_Commodity_Swap_Basis qualify_Commodity_Swap_Basis;
	@Inject protected Qualify_Commodity_Swap_FixedFloat qualify_Commodity_Swap_FixedFloat;
	@Inject protected Qualify_Commodity_Swaption qualify_Commodity_Swaption;
	@Inject protected Qualify_InterestRate_Forward_Debt qualify_InterestRate_Forward_Debt;
	@Inject protected Qualify_InterestRate_Option_Swaption qualify_InterestRate_Option_Swaption;
	@Inject protected UnderlierForProduct underlierForProduct;

	/**
	* @param product 
	* @param tradeLot 
	* @param reportableInformation 
	* @return payoutLeg 
	*/
	public PayoutLegWithAuxiliary evaluate(Product product, TradeLot tradeLot, ReportableInformation reportableInformation) {
		PayoutLegWithAuxiliary.PayoutLegWithAuxiliaryBuilder payoutLegBuilder = doEvaluate(product, tradeLot, reportableInformation);
		
		final PayoutLegWithAuxiliary payoutLeg;
		if (payoutLegBuilder == null) {
			payoutLeg = null;
		} else {
			payoutLeg = payoutLegBuilder.build();
			objectValidator.validate(PayoutLegWithAuxiliary.class, payoutLeg);
		}
		
		return payoutLeg;
	}

	protected abstract PayoutLegWithAuxiliary.PayoutLegWithAuxiliaryBuilder doEvaluate(Product product, TradeLot tradeLot, ReportableInformation reportableInformation);

	public static class PayoutLeg1Default extends PayoutLeg1 {
		@Override
		protected PayoutLegWithAuxiliary.PayoutLegWithAuxiliaryBuilder doEvaluate(Product product, TradeLot tradeLot, ReportableInformation reportableInformation) {
			PayoutLegWithAuxiliary.PayoutLegWithAuxiliaryBuilder payoutLeg = PayoutLegWithAuxiliary.builder();
			return assignOutput(payoutLeg, product, tradeLot, reportableInformation);
		}
		
		protected PayoutLegWithAuxiliary.PayoutLegWithAuxiliaryBuilder assignOutput(PayoutLegWithAuxiliary.PayoutLegWithAuxiliaryBuilder payoutLeg, Product product, TradeLot tradeLot, ReportableInformation reportableInformation) {
			final Boolean boolean0 = isCreditSwaption.evaluate(product);
			if ((boolean0 == null ? false : boolean0)) {
				payoutLeg = toBuilder(PayoutLegWithAuxiliary.builder()
					.setCreditDefaultPayout(MapperS.of(economicTermsForProduct.evaluate(underlierForProduct.evaluate(product))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).get())
					.build());
			} else {
				final Boolean boolean1 = isCreditDefaultSwap.evaluate(product);
				if ((boolean1 == null ? false : boolean1)) {
					payoutLeg = toBuilder(PayoutLegWithAuxiliary.builder()
						.setCreditDefaultPayout(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).get())
						.build());
				} else if (ComparisonResult.of(MapperS.of(isEquityOption.evaluate(product))).or(ComparisonResult.of(MapperS.of(isInterestRateDebtOption.evaluate(product)))).or(ComparisonResult.of(MapperS.of(isProductETD.evaluate(product))).and(exists(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout())))).getOrDefault(false)) {
					payoutLeg = toBuilder(PayoutLegWithAuxiliary.builder()
						.setOptionPayout(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).get())
						.setTradeLot(tradeLot)
						.setIsProductETD(isProductETD.evaluate(product))
						.build());
				} else {
					final Boolean boolean2 = qualify_InterestRate_Option_Swaption.evaluate(economicTermsForProduct.evaluate(product));
					if ((boolean2 == null ? false : boolean2)) {
						payoutLeg = toBuilder(PayoutLegWithAuxiliary.builder()
							.setInterestRatePayout(interestRateLeg1.evaluate(underlierForProduct.evaluate(product)))
							.build());
					} else if (ComparisonResult.of(MapperS.of(isEquityForward.evaluate(product))).or(ComparisonResult.of(MapperS.of(isProductETD.evaluate(product))).and(exists(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<ForwardPayout>mapC("getForwardPayout", payout -> payout.getForwardPayout())))).getOrDefault(false)) {
						payoutLeg = toBuilder(PayoutLegWithAuxiliary.builder()
							.setForwardPayout(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<ForwardPayout>mapC("getForwardPayout", payout -> payout.getForwardPayout()).get())
							.setTradeLot(tradeLot)
							.setIsProductETD(isProductETD.evaluate(product))
							.build());
					} else if (ComparisonResult.of(MapperS.of(isEquity.evaluate(product))).or(ComparisonResult.of(MapperS.of(isTotalReturnSwapDebtUnderlier.evaluate(product)))).getOrDefault(false)) {
						payoutLeg = toBuilder(PayoutLegWithAuxiliary.builder()
							.setPerformancePayout(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).get())
							.setTradeLot(tradeLot)
							.build());
					} else if (ComparisonResult.of(MapperS.of(isFXForward.evaluate(product))).or(ComparisonResult.of(MapperS.of(isFXOption.evaluate(product)))).getOrDefault(false)) {
						payoutLeg = toBuilder(PayoutLegWithAuxiliary.builder()
							.setCashflow(fXLeg1.evaluate(product))
							.build());
					} else {
						final Boolean boolean3 = isFXSwap.evaluate(product);
						if ((boolean3 == null ? false : boolean3)) {
							payoutLeg = toBuilder(PayoutLegWithAuxiliary.builder()
								.setCashflow(fXSwapLeg1.evaluate(product))
								.build());
						} else {
							final Boolean boolean4 = isCommodityOption.evaluate(product);
							if ((boolean4 == null ? false : boolean4)) {
								payoutLeg = toBuilder(PayoutLegWithAuxiliary.builder()
									.setOptionPayout(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).get())
									.setTradeLot(tradeLot)
									.setLastAvailableSpotPrice(lastAvailableSpotPrice.evaluate(reportableInformation))
									.setIsProductETD(isProductETD.evaluate(product))
									.build());
							} else {
								final Boolean boolean5 = qualify_Commodity_Swap_FixedFloat.evaluate(economicTermsForProduct.evaluate(product));
								if ((boolean5 == null ? false : boolean5)) {
									payoutLeg = toBuilder(PayoutLegWithAuxiliary.builder()
										.setFixedPricePayout(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<FixedPricePayout>mapC("getFixedPricePayout", payout -> payout.getFixedPricePayout()).get())
										.build());
								} else if (ComparisonResult.of(MapperS.of(qualify_Commodity_Swaption.evaluate(economicTermsForProduct.evaluate(product)))).and(ComparisonResult.of(MapperS.of(qualify_Commodity_Swap_FixedFloat.evaluate(economicTermsForProduct.evaluate(underlierForProduct.evaluate(product)))))).getOrDefault(false)) {
									payoutLeg = toBuilder(PayoutLegWithAuxiliary.builder()
										.setFixedPricePayout(MapperS.of(economicTermsForProduct.evaluate(underlierForProduct.evaluate(product))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<FixedPricePayout>mapC("getFixedPricePayout", payout -> payout.getFixedPricePayout()).get())
										.build());
								} else if (ComparisonResult.of(MapperS.of(qualify_Commodity_Swaption.evaluate(economicTermsForProduct.evaluate(product)))).and(ComparisonResult.of(MapperS.of(qualify_Commodity_Swap_Basis.evaluate(economicTermsForProduct.evaluate(underlierForProduct.evaluate(product)))))).getOrDefault(false)) {
									final CommodityPayout ifThenElseResult0;
									if (exists(MapperS.of(lastAvailableSpotPrice.evaluate(reportableInformation))).getOrDefault(false)) {
										ifThenElseResult0 = commodityBasisLegWithNoSpread.evaluate(underlierForProduct.evaluate(product));
									} else {
										ifThenElseResult0 = commodityLeg1.evaluate(underlierForProduct.evaluate(product));
									}
									payoutLeg = toBuilder(PayoutLegWithAuxiliary.builder()
										.setCommodityPayout(ifThenElseResult0)
										.setTradeLot(tradeLot)
										.setLastAvailableSpotPrice(lastAvailableSpotPrice.evaluate(reportableInformation))
										.build());
								} else {
									final Boolean boolean6 = qualify_Commodity_Swap_Basis.evaluate(economicTermsForProduct.evaluate(product));
									if ((boolean6 == null ? false : boolean6)) {
										final CommodityPayout ifThenElseResult1;
										if (exists(MapperS.of(lastAvailableSpotPrice.evaluate(reportableInformation))).getOrDefault(false)) {
											ifThenElseResult1 = commodityBasisLegWithNoSpread.evaluate(product);
										} else {
											ifThenElseResult1 = commodityLeg1.evaluate(product);
										}
										payoutLeg = toBuilder(PayoutLegWithAuxiliary.builder()
											.setCommodityPayout(ifThenElseResult1)
											.setTradeLot(tradeLot)
											.setLastAvailableSpotPrice(lastAvailableSpotPrice.evaluate(reportableInformation))
											.build());
									} else {
										final Boolean boolean7 = isSingleCommodityPayoutProduct.evaluate(product);
										if ((boolean7 == null ? false : boolean7)) {
											payoutLeg = toBuilder(PayoutLegWithAuxiliary.builder()
												.setCommodityPayout(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CommodityPayout>mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).get())
												.setTradeLot(tradeLot)
												.setLastAvailableSpotPrice(lastAvailableSpotPrice.evaluate(reportableInformation))
												.build());
										} else {
											final Boolean boolean8 = isCommodityFixedPriceForward.evaluate(product);
											if ((boolean8 == null ? false : boolean8)) {
												payoutLeg = toBuilder(PayoutLegWithAuxiliary.builder()
													.setFixedPricePayout(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<FixedPricePayout>mapC("getFixedPricePayout", payout -> payout.getFixedPricePayout()).get())
													.build());
											} else {
												final Boolean boolean9 = isCommodityFloatingPriceForward.evaluate(product);
												if ((boolean9 == null ? false : boolean9)) {
													payoutLeg = toBuilder(PayoutLegWithAuxiliary.builder()
														.setCommodityPayout(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CommodityPayout>mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).get())
														.setTradeLot(tradeLot)
														.setLastAvailableSpotPrice(lastAvailableSpotPrice.evaluate(reportableInformation))
														.build());
												} else {
													final Boolean boolean10 = isFixedFloatZeroCouponSwapKnownAmount.evaluate(product);
													if ((boolean10 == null ? false : boolean10)) {
														payoutLeg = toBuilder(PayoutLegWithAuxiliary.builder()
															.setInterestRatePayout(interestRateLeg2FixedFloatSingleCurrency.evaluate(product))
															.build());
													} else {
														final Boolean boolean11 = qualify_InterestRate_Forward_Debt.evaluate(economicTermsForProduct.evaluate(product));
														if ((boolean11 == null ? false : boolean11)) {
															payoutLeg = toBuilder(PayoutLegWithAuxiliary.builder()
																.setForwardPayout(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<ForwardPayout>mapC("getForwardPayout", payout -> payout.getForwardPayout()).get())
																.build());
														} else {
															final Boolean boolean12 = qualify_AssetClass_InterestRate.evaluate(economicTermsForProduct.evaluate(product));
															if ((boolean12 == null ? false : boolean12)) {
																payoutLeg = toBuilder(PayoutLegWithAuxiliary.builder()
																	.setInterestRatePayout(interestRateLeg1.evaluate(product))
																	.build());
															} else {
																payoutLeg = null;
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
			
			return Optional.ofNullable(payoutLeg)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
